/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.httpclient.State;
import org.apache.commons.httpclient.methods.GetMethod;

public class PostMethod
extends GetMethod {
    protected static final String POST = "POST";
    Hashtable parameters = new Hashtable();

    public PostMethod() {
        this.name = POST;
    }

    public PostMethod(String path) {
        super(path);
        this.name = POST;
    }

    public PostMethod(String path, String tempDir) {
        super(path, tempDir);
        this.name = POST;
    }

    public PostMethod(String path, boolean useDisk, String tempDir) {
        super(path, useDisk, tempDir);
        this.name = POST;
    }

    public PostMethod(String path, boolean useDisk, String tempDir, String tempFile) {
        super(path, useDisk, tempDir, tempFile);
        this.name = POST;
    }

    public void addParameter(String name, String value) {
        this.checkNotUsed();
        this.parameters.put(name, value);
    }

    public void recycle() {
        super.recycle();
        this.parameters.clear();
    }

    public void generateHeaders(String host, State state) {
        super.generateHeaders(host, state);
        if (!this.parameters.isEmpty()) {
            super.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    public String generateQuery() {
        if (!this.parameters.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Enumeration names = this.parameters.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = (String)this.parameters.get(name);
                sb.append(URLEncoder.encode(name));
                sb.append("=");
                sb.append(URLEncoder.encode(value));
                if (!names.hasMoreElements()) continue;
                sb.append("&");
            }
            return sb.toString();
        }
        return null;
    }

    public boolean needContentLength() {
        return true;
    }
}

