/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;

public class OptionsMethod
extends HttpMethodBase {
    private Vector methodsAllowed = new Vector();

    public OptionsMethod() {
        this.name = "OPTIONS";
    }

    public OptionsMethod(String path) {
        super(path);
        this.name = "OPTIONS";
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.methodsAllowed.contains(method);
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    public String generateQuery() {
        return null;
    }

    public void parseResponse(InputStream is) throws IOException {
    }

    public void processResponseHeaders(Hashtable headers) {
        Header allowHeader = (Header)headers.get("allow");
        if (allowHeader != null) {
            String allowHeaderValue = allowHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(allowHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String methodAllowed = tokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(methodAllowed);
            }
        }
    }

    public boolean needContentLength() {
        return false;
    }
}

