/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpMethodBase;

public class GetMethod
extends HttpMethodBase {
    public static final String TEMP_DIR = "temp/";
    protected boolean useDisk = true;
    protected byte[] memoryData;
    protected File fileData;
    protected String tempDir = "temp/";
    protected String tempFile = null;

    public GetMethod() {
        this.name = "GET";
        this.setFollowRedirects(true);
    }

    public GetMethod(String path) {
        super(path);
        this.name = "GET";
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir) {
        this(path);
        this.useDisk = true;
        this.setTempDir(tempDir);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, boolean useDisk, String tempDir) {
        this(path);
        this.setUseDisk(useDisk);
        if (useDisk) {
            this.setTempDir(tempDir);
        }
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir, String tempFile) {
        this(path);
        this.useDisk = true;
        this.setTempDir(tempDir);
        this.setTempFile(tempFile);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, boolean useDisk, String tempDir, String tempFile) {
        this(path);
        this.setUseDisk(useDisk);
        if (useDisk) {
            this.setTempDir(tempDir);
            this.setTempFile(tempFile);
        }
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, File fileData) {
        this(path);
        this.useDisk = true;
        this.fileData = fileData;
        this.setFollowRedirects(true);
    }

    public void setUseDisk(boolean useDisk) {
        this.checkNotUsed();
        this.useDisk = useDisk;
    }

    public boolean getUseDisk() {
        return this.useDisk;
    }

    public void setTempDir(String tempDir) {
        this.checkNotUsed();
        this.tempDir = tempDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempFile(String tempFile) {
        this.checkNotUsed();
        this.tempFile = tempFile;
    }

    public String getTempFile() {
        return this.tempFile;
    }

    public File getFileData() {
        return this.fileData;
    }

    public void setFileData(File fileData) {
        this.checkNotUsed();
        this.fileData = fileData;
    }

    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    public InputStream getData() throws IOException {
        this.checkUsed();
        if (this.useDisk) {
            return new FileInputStream(this.fileData);
        }
        if (this.memoryData == null) {
            throw new IOException("Data not found");
        }
        return new ByteArrayInputStream(this.memoryData);
    }

    public String getDataAsString() throws IOException {
        this.checkUsed();
        if (this.useDisk) {
            FileInputStream is = new FileInputStream(this.fileData);
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int nb = 0;
            while ((nb = ((InputStream)is).read(buffer)) != -1) {
                os.write(buffer, 0, nb);
            }
            ((InputStream)is).close();
            return os.toString();
        }
        if (this.memoryData != null) {
            return new String(this.memoryData);
        }
        return "";
    }

    public String generateQuery() {
        return null;
    }

    public void parseResponse(InputStream is) throws IOException {
        OutputStream out = null;
        if (this.useDisk) {
            if (this.fileData == null) {
                File dir = new File(this.tempDir);
                dir.mkdirs();
                String tempFileName = null;
                if (this.tempFile == null) {
                    String encodedPath = URLEncoder.encode(this.getPath());
                    int length = encodedPath.length();
                    if (length > 240) {
                        encodedPath = encodedPath.substring(length - 200, length);
                    }
                    tempFileName = System.currentTimeMillis() + "-" + encodedPath + ".tmp";
                } else {
                    tempFileName = this.tempFile;
                }
                this.fileData = new File(this.tempDir, tempFileName);
            }
            out = new FileOutputStream(this.fileData);
        } else {
            out = new ByteArrayOutputStream();
        }
        byte[] buffer = new byte[4096];
        int nb = 0;
        while ((nb = is.read(buffer)) != -1) {
            if (out == null) {
                throw new IOException("Unable to buffer data");
            }
            out.write(buffer, 0, nb);
        }
        if (!this.useDisk) {
            this.memoryData = ((ByteArrayOutputStream)out).toByteArray();
        }
        out.close();
    }

    public boolean needContentLength() {
        return false;
    }
}

