/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.Authenticator;
import org.apache.commons.httpclient.ConnectionInterceptor;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.RequestOutputStream;
import org.apache.commons.httpclient.ResponseInputStream;
import org.apache.commons.httpclient.State;
import org.apache.commons.httpclient.StreamInterceptor;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HttpClient {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpClient");
    private static final Log wireLog = LogSource.getInstance("httpclient.wire");
    public static final String DATE_FORMAT = "EEE, d MMM yyyy kk:mm:ss z";
    public static final Header USER_AGENT = new Header("User-Agent", "Jakarta HTTP Client/1.0");
    protected static final DateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z");
    protected Socket socket;
    protected State state;
    protected Credentials credentials;
    protected InputStream input;
    protected OutputStream output;
    protected String sessionHost = "";
    protected int proxyPort = -1;
    protected String proxyHost = null;
    protected int sessionPort = -1;
    protected boolean http11 = false;
    protected boolean https = false;
    protected StreamInterceptor streamInterceptor = null;
    protected ConnectionInterceptor connectionInterceptor = null;

    public HttpClient() {
    }

    public HttpClient(String user, String password) {
        if (null == this.state) {
            this.state = new State();
        }
        this.state.setDefaultCredentials(new Credentials(user, password));
    }

    public HttpClient(URL url) {
    }

    public HttpClient(URL url, String user, String password) {
        this(url);
        if (null == this.state) {
            this.state = new State();
        }
        this.state.setDefaultCredentials(new Credentials(user, password));
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setCredentials(Credentials credentials) {
        if (null == this.state) {
            this.state = new State();
        }
        this.state.setDefaultCredentials(credentials);
    }

    public void setCredentials(String realm, Credentials credentials) {
        if (null == this.state) {
            this.state = new State();
        }
        this.state.setCredentials(realm, credentials);
    }

    public Credentials getCredentials() {
        if (null == this.state) {
            return null;
        }
        return this.state.getDefaultCredentials();
    }

    public Credentials getCredentials(String realm) {
        if (null == this.state) {
            return null;
        }
        return this.state.getCredentials(realm);
    }

    public void setDebug(int debug) {
        log.setLevel(debug);
    }

    public int getDebug() {
        return log.getLevel();
    }

    public String getHost() {
        return this.sessionHost;
    }

    public int getPort() {
        return this.sessionPort;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getUserName() {
        if (null == this.state) {
            return null;
        }
        Credentials creds = this.state.getDefaultCredentials();
        return null == creds ? null : creds.getUserName();
    }

    public String getUserName(String realm) {
        if (null == this.state) {
            return null;
        }
        Credentials creds = this.state.getCredentials(realm);
        return null == creds ? null : creds.getUserName();
    }

    public String getPassword() {
        if (null == this.state) {
            return null;
        }
        Credentials creds = this.state.getDefaultCredentials();
        return null == creds ? null : creds.getPassword();
    }

    public String getPassword(String realm) {
        if (null == this.state) {
            return null;
        }
        Credentials creds = this.state.getCredentials(realm);
        return null == creds ? null : creds.getPassword();
    }

    public void setStreamInterceptor(StreamInterceptor streamInterceptor) {
        this.streamInterceptor = streamInterceptor;
    }

    StreamInterceptor getStreamInterceptor() {
        return this.streamInterceptor;
    }

    public void setConnectionInterceptor(ConnectionInterceptor connectionInterceptor) {
        this.connectionInterceptor = connectionInterceptor;
    }

    ConnectionInterceptor getConnectionInterceptor() {
        return this.connectionInterceptor;
    }

    public synchronized void executeMethod(HttpMethod method) throws IOException, HttpException {
        log.debug("HttpClient.executeMethod(HttpMethod)");
        int retries = 0;
        Hashtable responseHeaders = null;
        boolean methodProcessed = false;
        boolean sentRequestBody = false;
        String wwwAuthenticateValue = null;
        this.openConnection();
        while (retries < 5 && !methodProcessed) {
            log.debug("HttpClient.executeMethod(): trying " + retries + ".");
            try {
                Header authenticateChallenge;
                String statusLine;
                boolean closeOutput;
                responseHeaders = null;
                sentRequestBody = false;
                byte[] query = this.sendRequestHeader(method);
                if (!this.http11 || !method.needExpectation()) {
                    this.sendRequestBody(method, query);
                    sentRequestBody = true;
                }
                if (this.connectionInterceptor != null) {
                    this.connectionInterceptor.sentRequest();
                }
                if (closeOutput = this.needToCloseOutput(method)) {
                    try {
                        Class[] paramsClasses = new Class[]{};
                        Method shutdownOutput = this.socket.getClass().getMethod("shutdownOutput", paramsClasses);
                        Object[] params = new Object[]{};
                        shutdownOutput.invoke((Object)this.socket, params);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((statusLine = this.readLine(this.input)) == null) {
                    throw new IOException("Couldn't parse status line");
                }
                this.parseStatusLine(statusLine, method);
                responseHeaders = this.parseHeaders(this.input);
                while (method.getStatusCode() < 200) {
                    if (this.connectionInterceptor != null) {
                        this.connectionInterceptor.info(method.getStatusCode(), responseHeaders);
                    }
                    if (method.getStatusCode() == 100 && !sentRequestBody) {
                        if (this.connectionInterceptor != null) {
                            this.connectionInterceptor.receivedExpectation();
                        }
                        this.sendRequestBody(method, query);
                        sentRequestBody = true;
                    }
                    if ((statusLine = this.readLine(this.input)) == null) {
                        throw new IOException("Couldn't parse status line");
                    }
                    this.parseStatusLine(statusLine, method);
                    responseHeaders = this.parseHeaders(this.input);
                }
                if (this.connectionInterceptor != null) {
                    this.connectionInterceptor.receivedResponse();
                }
                if ((authenticateChallenge = (Header)responseHeaders.get("www-authenticate")) != null) {
                    wwwAuthenticateValue = authenticateChallenge.getValue();
                    this.state.setAuthenticateToken(wwwAuthenticateValue);
                    if (this.connectionInterceptor != null) {
                        this.connectionInterceptor.requiredAuthentication();
                    }
                }
                if (method.getStatusCode() == 302 || method.getStatusCode() == 301) {
                    if (method.followRedirects()) {
                        Header location = (Header)responseHeaders.get("location");
                        if (location != null) {
                            String absolutePath = location.getValue();
                            if (absolutePath.startsWith("http://")) {
                                absolutePath = absolutePath.substring(7);
                            } else if (absolutePath.startsWith("https://")) {
                                absolutePath = absolutePath.substring(8);
                            }
                            int slash = absolutePath.indexOf(47);
                            if (slash != -1) {
                                absolutePath = absolutePath.substring(slash);
                            }
                            if (absolutePath.equals("")) {
                                absolutePath = "/";
                            }
                            method.setPath(absolutePath);
                        }
                    } else {
                        methodProcessed = true;
                    }
                }
                if (method.getStatusCode() != 401 && method.getStatusCode() != 302 && method.getStatusCode() != 301 && method.getStatusCode() != 100) {
                    methodProcessed = true;
                } else if (!methodProcessed) {
                    log.debug("HttpClient.exectuteMethod(): Method not processed. Received status code \"" + method.getStatusCode() + "\". May retry.");
                    if (this.connectionInterceptor != null) {
                        this.connectionInterceptor.retry(method.getStatusCode());
                    }
                    method.processResponseHeaders(responseHeaders);
                    ResponseInputStream responseInputStream = new ResponseInputStream(this.input, method, responseHeaders);
                    responseInputStream.close();
                    if (closeOutput || this.needToCloseConnection(method, responseHeaders)) {
                        this.closeConnection();
                        this.openConnection();
                    }
                }
            }
            catch (IOException e) {
                if (this.connectionInterceptor != null) {
                    this.connectionInterceptor.error(method.getStatusCode(), e);
                }
                log.debug("HttpClient.executeMethod(): IOException while executing method, will close and try again.", e);
                try {
                    this.closeConnection();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.openConnection();
            }
            catch (HttpException e) {
                log.warn("HttpClient.executeMethod(): caught HTTP Exception: " + e.getMessage() + ", Status Code: " + e.getStatusCode(), e);
                if (this.connectionInterceptor != null) {
                    this.connectionInterceptor.error(e.getStatusCode(), e);
                }
                if (e.getStatusCode() > 0) {
                    method.setStatusCode(e.getStatusCode());
                }
                try {
                    this.closeConnection();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (e.getStatusCode() == -2) {
                    throw new HttpException(401);
                }
                this.openConnection();
            }
            ++retries;
        }
        if (retries == 5) {
            throw new HttpException("Unable to process request", method.getStatusCode());
        }
        method.processResponseHeaders(responseHeaders);
        method.setUsed();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.input, method, responseHeaders);
        responseInputStream.setInterceptor(this.streamInterceptor);
        method.parseResponse(responseInputStream);
        responseInputStream.close();
        if (this.needToCloseConnection(method, responseHeaders)) {
            this.closeConnection();
        }
    }

    public void startSession() {
        if (this.state == null) {
            this.state = new State();
        }
        this.sessionHost = "localhost";
        this.sessionPort = 80;
        this.https = false;
    }

    public void startSession(String host, int port) {
        this.startSession(host, port, false);
    }

    public void startSession(String host, int port, boolean https) {
        log.debug("HttpClient.startSession(String,int,boolean): Host:" + host + " Port:" + port + " HTTPS:" + https);
        if (this.state == null) {
            this.state = new State();
        }
        this.sessionHost = host;
        this.sessionPort = port;
        this.https = https;
    }

    public void startSession(String host, int port, Credentials creds) {
        this.startSession(host, port, creds, false);
    }

    public void startSession(String host, int port, Credentials creds, boolean https) {
        log.debug("HttpClient.startSession(String,int,Credentials,boolean): Host:" + host + " Port:" + port + " Credentials:" + creds + " HTTPS:" + https);
        this.setCredentials(creds);
        if (this.state == null) {
            this.state = new State();
        }
        this.sessionHost = host;
        this.sessionPort = port;
        this.https = https;
    }

    public void startSession(URL url) {
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 443 : url.getPort(), true);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 80 : url.getPort(), false);
        } else {
            throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
        }
    }

    public void startSession(URL url, Credentials creds) {
        this.setCredentials(creds);
        this.startSession(url);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport) {
        this.proxyHost = proxyhost;
        this.proxyPort = proxyport;
        this.startSession(host, port);
    }

    public void endSession() throws IOException {
        log.debug("HttpClient.endSession()");
        this.closeConnection();
        this.state = null;
        this.sessionHost = "";
        this.sessionPort = -1;
        this.https = false;
    }

    protected void openConnection() throws IOException, UnknownHostException {
        log.debug("HttpClient.openConnection()");
        try {
            if (this.socket == null) {
                if (this.proxyHost == null || this.proxyPort < 0) {
                    log.debug("HttpClient.openConnection(): Host:" + this.sessionHost + " Port:" + this.sessionPort);
                    this.socket = this.https ? SSLSocketFactory.getDefault().createSocket(this.sessionHost, this.sessionPort) : new Socket(this.sessionHost, this.sessionPort);
                } else {
                    log.debug("HttpClient.openConnection(): Proxied: Host:" + this.proxyHost + " Port:" + this.proxyPort);
                    this.socket = new Socket(this.proxyHost, this.proxyPort);
                }
            }
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (IOException e) {
            if (this.connectionInterceptor != null) {
                this.connectionInterceptor.error(-1, e);
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            throw e;
        }
        if (this.connectionInterceptor != null) {
            this.connectionInterceptor.connect();
        }
    }

    protected void closeConnection() throws IOException {
        log.debug("HttpClient.closeConnection()");
        if (this.input != null) {
            this.input.close();
        }
        this.input = null;
        if (this.output != null) {
            this.output.close();
        }
        this.output = null;
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.connectionInterceptor != null) {
            this.connectionInterceptor.disconnect();
        }
    }

    protected byte[] sendRequestHeader(HttpMethod method) throws IOException, HttpException {
        String challengeResponse;
        log.debug("HttpClient.sendRequestHeader(HttpMethod)");
        if (method.hasBeenUsed()) {
            throw new HttpException("Method has already been used");
        }
        if (!method.validate()) {
            throw new HttpException("Invalid method");
        }
        method.setState(this.state);
        String requestLine = this.proxyHost == null || this.proxyPort < 0 ? method.generateRequestLine() : method.generateRequestLine(this.getHost(), this.getPort());
        String hostName = this.sessionHost;
        if (this.sessionPort != 80) {
            hostName = hostName + ":" + this.sessionPort;
        }
        method.generateHeaders(hostName, this.state);
        Enumeration headersList = method.getHeaders();
        wireLog.info(">> \"" + requestLine + "\"");
        this.output.write(requestLine.getBytes());
        byte[] query = null;
        if (!method.isStreamedQuery()) {
            String queryStr = method.generateQuery();
            if (queryStr == null) {
                queryStr = new String();
            }
            query = queryStr.getBytes("UTF8");
            if (method.needContentLength()) {
                String contentLengthHeader = "Content-Length: " + query.length + "\r\n";
                wireLog.info(">> \"" + contentLengthHeader + "\"");
                this.output.write(contentLengthHeader.getBytes());
            }
        } else if (this.http11 && method.getHeader("Content-Length") == null) {
            String transferEncodingHeader = "Transfer-Encoding: chunked\r\n";
            wireLog.info(">> \"" + transferEncodingHeader + "\"");
            this.output.write(transferEncodingHeader.getBytes());
        }
        if (null != this.state.getAuthenticateToken() && (challengeResponse = Authenticator.challengeResponse(this.state.getAuthenticateToken(), this.state)) != null) {
            String authorizationHeader = "Authorization: " + challengeResponse + "\r\n";
            wireLog.info(">> \"" + authorizationHeader + "\"");
            this.output.write(authorizationHeader.getBytes());
            if (this.connectionInterceptor != null) {
                this.connectionInterceptor.authenticate();
            }
        }
        if (method.needExpectation()) {
            String expectHeader = "Expect: 100-continue\r\n";
            wireLog.info(">> \"" + expectHeader + "\"");
            this.output.write(expectHeader.getBytes());
        }
        while (headersList.hasMoreElements()) {
            Header header = (Header)headersList.nextElement();
            wireLog.info(">> \"" + header.toString() + "\"");
            this.output.write(header.toString().getBytes());
        }
        wireLog.info(">> \\r\\n (closing head)");
        this.output.write("\r\n".getBytes());
        return query;
    }

    protected void sendRequestBody(HttpMethod method, byte[] query) throws IOException, HttpException {
        RequestOutputStream requestOutputStream = new RequestOutputStream(this.output, method);
        requestOutputStream.setInterceptor(this.streamInterceptor);
        if (method.isStreamedQuery()) {
            if (this.http11 && method.getHeader("Content-Length") == null) {
                requestOutputStream.setUseChunking(true);
            }
            method.streamQuery(requestOutputStream);
        } else {
            wireLog.info(new String(query, "UTF8"));
            requestOutputStream.write(query);
        }
        requestOutputStream.close();
    }

    protected String readLine(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = input.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        wireLog.info("<< \"" + sb.toString() + "\"");
        return sb.toString();
    }

    protected void parseStatusLine(String statusLine, HttpMethod method) throws IOException, HttpException {
        log.debug("HttpClient.parseStatusLine(String,HttpMethod)");
        while (statusLine != null && !statusLine.startsWith("HTTP/")) {
            statusLine = this.readLine(this.input);
        }
        if (statusLine == null) {
            throw new HttpException("Error in parsing the response: " + statusLine);
        }
        if (!statusLine.startsWith("HTTP/1.1") && !statusLine.startsWith("HTTP/1.0")) {
            throw new HttpException("Incorrect server protocol :" + statusLine);
        }
        this.http11 = statusLine.startsWith("HTTP/1.1");
        int statusCode = -1;
        int at = statusLine.indexOf(" ");
        if (at < 0) {
            throw new HttpException("Error in parsing the response: " + statusLine);
        }
        int to = statusLine.indexOf(" ", at + 1);
        if (to < 0) {
            to = statusLine.length();
        }
        try {
            statusCode = Integer.parseInt(statusLine.substring(at + 1, to));
        }
        catch (NumberFormatException e) {
            throw new HttpException("Status not specified: " + statusLine);
        }
        method.setStatusCode(statusCode);
        String statusText = null;
        try {
            if (to < statusLine.length()) {
                statusText = statusLine.substring(to + 1);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HttpException("Status not specified: " + statusLine);
        }
        if (statusText != null) {
            method.setStatusText(statusText);
        }
    }

    protected Hashtable parseHeaders(InputStream input) throws IOException, HttpException {
        String line;
        log.debug("HttpClient.parseHeaders(InputStream)");
        Hashtable<String, Header> result = new Hashtable<String, Header>();
        while ((line = this.readLine(input)) != null && line.length() >= 1) {
            int colon = line.indexOf(":");
            if (colon < 0) {
                throw new HttpException("Incorrect headers");
            }
            String name = line.substring(0, colon).trim();
            String match = name.toLowerCase();
            String value = line.substring(colon + 1).trim();
            Header header = new Header(name, value);
            result.put(match, header);
        }
        Header header = (Header)result.get("set-cookie2");
        if (header == null) {
            header = (Header)result.get("set-cookie");
        }
        if (header != null) {
            try {
                Cookie[] cookies = Cookie.parse(this.sessionHost, header);
                this.state.addCookies(cookies);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected boolean needToCloseConnection(HttpMethod method, Hashtable responseHeaders) {
        if (!this.http11) {
            return true;
        }
        Header connectionHeader = (Header)responseHeaders.get("connection");
        if (connectionHeader != null && connectionHeader.getValue().equals("close")) {
            return true;
        }
        if (method.getStatusCode() < 200 || method.getStatusCode() == 204 || method.getStatusCode() == 304) {
            return false;
        }
        Header teHeader = (Header)responseHeaders.get("transfer-encoding");
        boolean chunk = teHeader != null && teHeader.getValue().indexOf("chunked") != -1;
        Header contentLengthHeader = (Header)responseHeaders.get("content-length");
        int contentLength = -1;
        if (contentLengthHeader != null) {
            try {
                contentLength = Integer.parseInt(contentLengthHeader.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return method.needContentLength() && contentLength == -1 && !chunk;
    }

    protected boolean needToCloseOutput(HttpMethod method) {
        if (!this.http11) {
            return method.isStreamedQuery() && method.getHeader("Content-Length") == null && method.needContentLength();
        }
        return false;
    }
}

