/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMConfigurationException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;

public abstract class DTMManager {
    private static final String defaultPropName = "org.apache.xml.dtm.DTMManager";
    protected XMLStringFactory m_xsf = null;
    public static boolean m_incremental = false;
    private static String foundFactory = null;
    private static boolean debug;
    public static final int IDENT_DTM_NODE_BITS = 16;
    public static final int IDENT_NODE_DEFAULT = 65535;
    public static final int IDENT_DTM_DEFAULT = -65536;
    public static final int IDENT_MAX_DTMS = 65536;
    static /* synthetic */ Class class$org$apache$xml$dtm$DTMManager;

    protected DTMManager() {
    }

    public XMLStringFactory getXMLStringFactory() {
        return this.m_xsf;
    }

    public void setXMLStringFactory(XMLStringFactory xsf) {
        this.m_xsf = xsf;
    }

    public static DTMManager newInstance(XMLStringFactory xsf) throws DTMConfigurationException {
        DTMManager factoryImpl;
        String classname = DTMManager.findFactory(defaultPropName, "org.apache.xml.dtm.ref.DTMManagerDefault");
        if (classname == null) {
            throw new DTMConfigurationException(XSLMessages.createMessage(156, null));
        }
        try {
            Class<?> clazz = Class.forName(classname);
            factoryImpl = (DTMManager)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new DTMConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new DTMConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new DTMConfigurationException(ie);
        }
        factoryImpl.setXMLStringFactory(xsf);
        return factoryImpl;
    }

    public abstract DTM getDTM(Source var1, boolean var2, DTMWSFilter var3, boolean var4, boolean var5);

    public abstract DTM getDTM(int var1);

    public abstract int getDTMHandleFromNode(Node var1);

    public abstract DTM createDocumentFragment();

    public abstract boolean release(DTM var1, boolean var2);

    public abstract DTMIterator createDTMIterator(Object var1, int var2);

    public abstract DTMIterator createDTMIterator(String var1, PrefixResolver var2);

    public abstract DTMIterator createDTMIterator(int var1, DTMFilter var2, boolean var3);

    public abstract DTMIterator createDTMIterator(int var1);

    public static synchronized boolean getIncremental() {
        return m_incremental;
    }

    public static synchronized void setIncremental(boolean incremental) {
        m_incremental = incremental;
    }

    private static String findFactory(String factoryId, String defaultFactory) {
        block19: {
            block18: {
                try {
                    String systemProp = null;
                    try {
                        systemProp = System.getProperty(factoryId);
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("DTM: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println("DTM: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block18;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                ClassLoader cl = (class$org$apache$xml$dtm$DTMManager == null ? (class$org$apache$xml$dtm$DTMManager = DTMManager.class$(defaultPropName)) : class$org$apache$xml$dtm$DTMManager).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("DTM: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("DTM: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    public abstract int getDTMIdentity(DTM var1);

    public int getDTMIdentityMask() {
        return -65536;
    }

    public int getNodeIdentityMask() {
        return 65535;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = System.getProperty("dtm.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

