/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.IOException;
import java.io.Writer;

public class JSourceWriter
extends Writer {
    public static final char DEFAULT_CHAR = ' ';
    public static final short DEFAULT_SIZE = 4;
    private String lineSeparator = System.getProperty("line.separator");
    private boolean addIndentation = true;
    private boolean autoflush = false;
    private short tabSize = (short)4;
    private char[] tab;
    private char tabChar = (char)32;
    private short tabLevel = 0;
    private Writer out = null;

    public JSourceWriter(Writer writer) {
        this(writer, 4, ' ', false);
    }

    public JSourceWriter(Writer writer, short s, char c, boolean bl) {
        this.out = writer;
        this.autoflush = bl;
        this.tabChar = c;
        this.tabSize = s;
        this.createTab();
    }

    public JSourceWriter(Writer writer, short s, boolean bl) {
        this(writer, s, ' ', bl);
    }

    public JSourceWriter(Writer writer, boolean bl) {
        this(writer, 4, ' ', bl);
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {}
    }

    private void createTab() {
        this.tab = new char[this.tabSize];
        int n = 0;
        while (n < this.tabSize) {
            this.tab[n] = this.tabChar;
            ++n;
        }
    }

    private void ensureIndent() {
        if (this.addIndentation) {
            this.writeIndent();
            this.addIndentation = false;
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {}
    }

    protected char getIndentChar() {
        return this.tabChar;
    }

    protected short getIndentLevel() {
        return this.tabLevel;
    }

    protected short getIndentSize() {
        return (short)(this.tabLevel * this.tabSize);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void indent() {
        this.tabLevel = (short)(this.tabLevel + 1);
    }

    public boolean isNewline() {
        return this.addIndentation;
    }

    private void linefeed() {
        try {
            this.out.write(this.lineSeparator);
        }
        catch (IOException iOException) {}
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void unindent() {
        if (this.tabLevel > 0) {
            this.tabLevel = (short)(this.tabLevel - 1);
        }
    }

    public void write(double d) {
        this.write(String.valueOf(d));
    }

    public void write(float f) {
        this.write(String.valueOf(f));
    }

    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(n);
            }
            catch (IOException iOException) {}
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void write(long l) {
        this.write(String.valueOf(l));
    }

    public void write(Object object) {
        this.write(object.toString());
    }

    public void write(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(string);
            }
            catch (IOException iOException) {}
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(string, n, n2);
            }
            catch (IOException iOException) {}
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void write(boolean bl) {
        this.write(String.valueOf(bl));
    }

    public void write(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(cArray);
            }
            catch (IOException iOException) {}
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(cArray, n, n2);
            }
            catch (IOException iOException) {}
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    protected void writeIndent() {
        try {
            int n = 0;
            while (n < this.tabLevel) {
                this.out.write(this.tab);
                ++n;
            }
        }
        catch (IOException iOException) {}
    }

    public void writeln() {
        Object object = this.lock;
        synchronized (object) {
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(c);
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(d));
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(f));
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(n));
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(l));
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.ensureIndent();
            try {
                this.out.write(object.toString());
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(string);
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(bl));
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void writeln(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(cArray);
            }
            catch (IOException iOException) {}
            this.linefeed();
            this.addIndentation = true;
        }
    }
}

