/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.ValidationException;

public abstract class PatternValidator {
    private String _pattern = null;
    private RegExpEvaluator _regex = null;

    public PatternValidator() {
    }

    public PatternValidator(String string) {
        this._pattern = string;
    }

    public String getPattern() {
        return this._pattern;
    }

    public boolean hasPattern() {
        return this._pattern != null;
    }

    private void initEvaluator() {
        this._regex = Configuration.getRegExpEvaluator();
        if (this._regex == null) {
            this._regex = new DefaultRegExpEvaluator();
        }
        this._regex.setExpression(this._pattern);
    }

    public void setPattern(String string) {
        this._pattern = string;
        if (this._regex != null) {
            this._regex.setExpression(this._pattern);
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "PatternValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        this.validate(object.toString());
    }

    public void validate(String string) throws ValidationException {
        if (this._pattern != null) {
            if (this._regex == null) {
                this.initEvaluator();
            }
            if (!this._regex.matches(string)) {
                String string2 = "objects of this type must match the  following regular expression: " + this._pattern;
                throw new ValidationException(string2);
            }
        }
    }

    class DefaultRegExpEvaluator
    implements RegExpEvaluator {
        DefaultRegExpEvaluator() {
        }

        public boolean matches(String string) {
            return false;
        }

        public void setExpression(String string) {
        }
    }
}

