/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SchemaWriter {
    private DocumentHandler _handler = null;
    private AttributeListImpl _atts = new AttributeListImpl();
    public static boolean enable = false;

    public SchemaWriter(Writer writer) throws IOException {
        Serializer serializer;
        if (!enable) {
            SchemaWriter.unsupported();
        }
        if ((serializer = Configuration.getSerializer()) == null) {
            throw new IOException("Unable to obtain serailizer");
        }
        serializer.setOutputCharStream(writer);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            String string = "The following serializer is not SAX capable: ";
            string = String.valueOf(string) + serializer.getClass().getName();
            string = String.valueOf(string) + "; cannot proceed.";
            throw new IOException(string);
        }
        this._handler = documentHandler;
    }

    public SchemaWriter(DocumentHandler documentHandler) {
        if (!enable) {
            SchemaWriter.unsupported();
        }
        if (documentHandler == null) {
            throw new IllegalArgumentException("DocumentHandler must not be null.");
        }
        this._handler = documentHandler;
    }

    private void processAnnotated(Annotated annotated) throws SAXException {
        Enumeration enumeration = annotated.getAnnotations();
        while (enumeration.hasMoreElements()) {
            this.processAnnotation((Annotation)enumeration.nextElement());
        }
    }

    private void processAnnotation(Annotation annotation) throws SAXException {
        this._atts.clear();
        String string = "xs:annotation";
        this._handler.startElement(string, this._atts);
        Enumeration enumeration = annotation.getDocumentation();
        while (enumeration.hasMoreElements()) {
            Documentation documentation = (Documentation)enumeration.nextElement();
            String string2 = documentation.getContent();
            if (string2 == null || string2.length() <= 0) continue;
            char[] cArray = string2.toCharArray();
            this._handler.startElement("xs:documentation", this._atts);
            this._handler.characters(cArray, 0, cArray.length);
            this._handler.endElement("xs:documentation");
        }
        this._handler.endElement(string);
    }

    private void processAttribute(AttributeDecl attributeDecl) throws SAXException {
        String string = "xs:attribute";
        this._atts.clear();
        String string2 = attributeDecl.getName();
        this._atts.addAttribute("name", null, string2);
        boolean bl = false;
        SimpleType simpleType = attributeDecl.getSimpleType();
        if (simpleType.getName() != null) {
            this._atts.addAttribute("type", null, simpleType.getName());
        } else {
            bl = true;
        }
        if (attributeDecl.isRequired()) {
            this._atts.addAttribute("use", null, "required");
        } else if (attributeDecl.isFixed()) {
            this._atts.addAttribute("use", null, "fixed");
            this._atts.addAttribute("value", null, attributeDecl.getValue());
        }
        this._handler.startElement(string, this._atts);
        this.processAnnotated(attributeDecl);
        if (bl) {
            this.processSimpleType(simpleType);
        }
        this._handler.endElement(string);
    }

    private void processComplexType(ComplexType complexType) throws SAXException {
        String string = "xs:complexType";
        this._atts.clear();
        if (complexType.isTopLevel()) {
            this._atts.addAttribute("name", null, complexType.getName());
        }
        this._handler.startElement(string, this._atts);
        this.processAnnotated(complexType);
        this.processContentModelGroup(complexType);
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            this.processAttribute((AttributeDecl)enumeration.nextElement());
        }
        this._handler.endElement(string);
    }

    private void processContentModelGroup(ContentModelGroup contentModelGroup) throws SAXException {
        Enumeration enumeration = contentModelGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 7: {
                    this.processElement((ElementDecl)structure);
                    break;
                }
                case 9: {
                    this.processGroup((Group)structure);
                    break;
                }
            }
        }
    }

    private void processElement(ElementDecl elementDecl) throws SAXException {
        XMLType xMLType;
        Object object;
        String string = "xs:element";
        this._atts.clear();
        String string2 = elementDecl.getName();
        if (string2 != null) {
            if (elementDecl.isReference()) {
                this._atts.addAttribute("ref", null, string2);
            } else {
                this._atts.addAttribute("name", null, string2);
            }
        }
        int n = elementDecl.getMaxOccurs();
        int n2 = elementDecl.getMinOccurs();
        if (n2 != 1) {
            this._atts.addAttribute("minOccurs", null, Integer.toString(n2));
        }
        if (n < 0) {
            this._atts.addAttribute("maxOccurs", null, "unbounded");
        } else if (n > 1) {
            this._atts.addAttribute("maxOccurs", null, Integer.toString(n));
        }
        boolean bl = false;
        if (!elementDecl.isReference()) {
            object = elementDecl.getType();
            if (((XMLType)object).getName() != null) {
                this._atts.addAttribute("type", null, ((XMLType)object).getName());
            } else {
                bl = true;
            }
        }
        if ((object = elementDecl.getDefaultValue()) != null) {
            this._atts.addAttribute("default", null, (String)object);
        }
        this._handler.startElement(string, this._atts);
        this.processAnnotated(elementDecl);
        if (bl && (xMLType = elementDecl.getType()).isComplexType()) {
            this.processComplexType((ComplexType)xMLType);
        }
        this._handler.endElement(string);
    }

    private void processGroup(Group group) throws SAXException {
        String string = "xs:" + group.getOrder().toString();
        this._atts.clear();
        String string2 = group.getName();
        if (string2 != null) {
            this._atts.addAttribute("name", null, string2);
        }
        this._handler.startElement(string, this._atts);
        this.processAnnotated(group);
        this.processContentModelGroup(group);
        this._handler.endElement(string);
    }

    private void processSchema(Schema schema) throws SAXException {
        String string = "xs:schema";
        this._handler.startDocument();
        this._atts.addAttribute("xmlns:xsd", null, schema.getSchemaNamespace());
        String string2 = schema.getTargetNamespace();
        if (string2 != null) {
            this._atts.addAttribute("targetNS", null, string2);
        }
        this._handler.startElement(string, this._atts);
        this.processAnnotated(schema);
        Enumeration enumeration = null;
        enumeration = schema.getElementDecls();
        while (enumeration.hasMoreElements()) {
            this.processElement((ElementDecl)enumeration.nextElement());
        }
        enumeration = schema.getComplexTypes();
        while (enumeration.hasMoreElements()) {
            this.processComplexType((ComplexType)enumeration.nextElement());
        }
        enumeration = schema.getSimpleTypes();
        while (enumeration.hasMoreElements()) {
            this.processSimpleType((SimpleType)enumeration.nextElement());
        }
        this._handler.endElement(string);
        this._handler.endDocument();
    }

    private void processSimpleType(SimpleType simpleType) throws SAXException {
        if (simpleType.isBuiltInType()) {
            return;
        }
        String string = "xs:simpleType";
        this._atts.clear();
        String string2 = simpleType.getName();
        if (string2 != null) {
            this._atts.addAttribute("name", null, string2);
        }
        this._handler.startElement(string, this._atts);
        SimpleType simpleType2 = (SimpleType)simpleType.getBaseType();
        if (simpleType2 != null) {
            this._atts.clear();
            this._atts.addAttribute("base", null, simpleType2.getName());
            this._handler.startElement("xs:restriction", this._atts);
            Enumeration enumeration = simpleType.getFacets();
            while (enumeration.hasMoreElements()) {
                Facet facet = (Facet)enumeration.nextElement();
                this._atts.clear();
                this._atts.addAttribute("value", null, facet.getValue());
                String string3 = "xs:" + facet.getName();
                this._handler.startElement(string3, this._atts);
                this._handler.endElement(string3);
            }
            this._handler.endElement("xs:restriction");
        }
        this._handler.endElement(string);
    }

    private static final void unsupported() {
        String string = "This class is not yet supported.  If you really wish to use it, and you promise not to  complain about unsupported features, then set  SchemaWriter.enable to true, before you attempt to construct  this class.";
        throw new IllegalStateException(string);
    }

    public void write(Schema schema) throws SAXException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        this.processSchema(schema);
    }
}

