/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.FacetUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SimpleTypeRestrictionUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private SimpleTypeDefinition _typeDefinition = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundFacets = false;

    public SimpleTypeRestrictionUnmarshaller(SimpleTypeDefinition simpleTypeDefinition, AttributeList attributeList) throws SAXException {
        this._typeDefinition = simpleTypeDefinition;
        this._schema = simpleTypeDefinition.getSchema();
        String string = attributeList.getValue("base");
        if (string != null && string.length() > 0) {
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._typeDefinition.setBaseTypeName(string);
            } else {
                if (xMLType.getStructureType() == 5) {
                    String string2 = "The base type of a simpleType cannot be a complexType.";
                    throw new IllegalStateException(string2);
                }
                this._typeDefinition.setBaseType((SimpleType)xMLType);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "restriction";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._typeDefinition.setAnnotation(annotation);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = (SimpleType)this.unmarshaller.getObject();
            this._typeDefinition.setBaseType(simpleType);
        } else {
            this._typeDefinition.addFacet((Facet)this.unmarshaller.getObject());
        }
        this.unmarshaller = null;
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if (string.equals("annotation")) {
            if (this.foundFacets || this.foundSimpleType) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'restriction' elements.");
            }
            if (this.foundFacets) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any facets.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else if (FacetUnmarshaller.isFacet(string)) {
            this.foundFacets = true;
            this.unmarshaller = new FacetUnmarshaller(string, attributeList);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

