/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.ArrayList;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;

public final class OID {
    private final Object _identity;
    private final String _name;
    private final LockEngine _engine;
    private final ClassMolder _molder;
    private final OID _depends;
    private Object _stamp;
    private boolean _dbLock;
    private final int _hashCode;
    private String _topClassName;
    private String[] _superClassNames;

    OID(LockEngine lockEngine, ClassMolder classMolder, Object object) {
        this(lockEngine, classMolder, null, object);
    }

    OID(LockEngine lockEngine, ClassMolder classMolder, OID oID, Object object) {
        ArrayList<String> arrayList = null;
        if (lockEngine == null) {
            throw new IllegalArgumentException("engine can't be null");
        }
        if (classMolder == null) {
            throw new IllegalArgumentException("molder can't be null");
        }
        if (object instanceof Object[]) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("identity can't be object array!");
            throw illegalArgumentException;
        }
        this._engine = lockEngine;
        this._molder = classMolder;
        this._identity = object;
        this._name = classMolder.getName();
        this._depends = oID;
        while (classMolder.getExtends() != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            classMolder = classMolder.getExtends();
            arrayList.add(classMolder.getName());
        }
        this._topClassName = classMolder.getName();
        if (arrayList != null) {
            this._superClassNames = new String[arrayList.size()];
            arrayList.toArray(this._superClassNames);
        }
        this._hashCode = this._topClassName.hashCode() + (this._identity == null ? 0 : this._identity.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        OID oID = (OID)object;
        return this._topClassName.equals(oID._topClassName) && this._identity != null && this._identity.equals(oID._identity);
    }

    public OID getDepends() {
        return this._depends;
    }

    Object getIdentity() {
        return this._identity;
    }

    LockEngine getLockEngine() {
        return this._engine;
    }

    ClassMolder getMolder() {
        return this._molder;
    }

    String getName() {
        return this._name;
    }

    Object getStamp() {
        return this._stamp;
    }

    String[] getSuperClassNames() {
        return this._superClassNames;
    }

    public int hashCode() {
        return this._hashCode;
    }

    boolean isDbLock() {
        return this._dbLock;
    }

    void setDbLock(boolean bl) {
        this._dbLock = bl;
    }

    void setStamp(Object object) {
        this._stamp = object;
    }

    public String toString() {
        return String.valueOf(this._name) + "/" + (this._identity == null ? "<new>" : this._identity.toString());
    }
}

