
# -----------------------------------------------------------------------
# TURBINE_USER
# -----------------------------------------------------------------------
drop table if exists TURBINE_USER;

CREATE TABLE TURBINE_USER
(
                            USER_ID INTEGER NOT NULL AUTO_INCREMENT,
                    LOGIN_NAME VARCHAR (32) NOT NULL,
                    PASSWORD_VALUE VARCHAR (32) NOT NULL,
                    FIRST_NAME VARCHAR (99) NOT NULL,
                    LAST_NAME VARCHAR (99) NOT NULL,
                    EMAIL VARCHAR (99),
                    CONFIRM_VALUE VARCHAR (99),
                    MODIFIED TIMESTAMP,
                    CREATED TIMESTAMP,
                    LAST_LOGIN TIMESTAMP,
                    DISABLED CHAR (1),
                    OBJECTDATA BLOB,
                    PASSWORD_CHANGED TIMESTAMP,
    PRIMARY KEY(USER_ID),
    UNIQUE (LOGIN_NAME)
);

# -----------------------------------------------------------------------
# TURBINE_ROLE
# -----------------------------------------------------------------------
drop table if exists TURBINE_ROLE;

CREATE TABLE TURBINE_ROLE
(
                            ROLE_ID INTEGER NOT NULL AUTO_INCREMENT,
                    ROLE_NAME VARCHAR (99) NOT NULL,
                    OBJECTDATA BLOB,
    PRIMARY KEY(ROLE_ID),
    UNIQUE (ROLE_NAME)
);

# -----------------------------------------------------------------------
# TURBINE_GROUP
# -----------------------------------------------------------------------
drop table if exists TURBINE_GROUP;

CREATE TABLE TURBINE_GROUP
(
                            GROUP_ID INTEGER NOT NULL AUTO_INCREMENT,
                    GROUP_NAME VARCHAR (99) NOT NULL,
                    OBJECTDATA BLOB,
    PRIMARY KEY(GROUP_ID),
    UNIQUE (GROUP_NAME)
);

# -----------------------------------------------------------------------
# TURBINE_PERMISSION
# -----------------------------------------------------------------------
drop table if exists TURBINE_PERMISSION;

CREATE TABLE TURBINE_PERMISSION
(
                            PERMISSION_ID INTEGER NOT NULL AUTO_INCREMENT,
                    PERMISSION_NAME VARCHAR (99) NOT NULL,
                    OBJECTDATA BLOB,
    PRIMARY KEY(PERMISSION_ID),
    UNIQUE (PERMISSION_NAME)
);

# -----------------------------------------------------------------------
# TURBINE_ROLE_PERMISSION
# -----------------------------------------------------------------------
drop table if exists TURBINE_ROLE_PERMISSION;

CREATE TABLE TURBINE_ROLE_PERMISSION
(
        ROLE_ID INTEGER NOT NULL,
        PERMISSION_ID INTEGER NOT NULL,
    PRIMARY KEY(ROLE_ID,PERMISSION_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID),
    FOREIGN KEY (PERMISSION_ID) REFERENCES TURBINE_PERMISSION (PERMISSION_ID)
);

# -----------------------------------------------------------------------
# TURBINE_USER_GROUP_ROLE
# -----------------------------------------------------------------------
drop table if exists TURBINE_USER_GROUP_ROLE;

CREATE TABLE TURBINE_USER_GROUP_ROLE
(
        USER_ID INTEGER NOT NULL,
        GROUP_ID INTEGER NOT NULL,
        ROLE_ID INTEGER NOT NULL,
    PRIMARY KEY(USER_ID,GROUP_ID,ROLE_ID),
    FOREIGN KEY (USER_ID) REFERENCES TURBINE_USER (USER_ID),
    FOREIGN KEY (GROUP_ID) REFERENCES TURBINE_GROUP (GROUP_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID)
);
  

# -----------------------------------------------------------------------
# JETSPEED_USER_PROFILE
# -----------------------------------------------------------------------
drop table if exists JETSPEED_USER_PROFILE;

CREATE TABLE JETSPEED_USER_PROFILE
(
                            PSML_ID INTEGER NOT NULL AUTO_INCREMENT,
                    USER_NAME VARCHAR (32) NOT NULL,
                    MEDIA_TYPE VARCHAR (99),
                    LANGUAGE VARCHAR (2),
                    COUNTRY VARCHAR (2),
                    PAGE VARCHAR (99),
                    PROFILE BLOB,
    PRIMARY KEY(PSML_ID),
    UNIQUE (USER_NAME, MEDIA_TYPE, LANGUAGE, COUNTRY, PAGE)
);

# -----------------------------------------------------------------------
# JETSPEED_GROUP_PROFILE
# -----------------------------------------------------------------------
drop table if exists JETSPEED_GROUP_PROFILE;

CREATE TABLE JETSPEED_GROUP_PROFILE
(
                            PSML_ID INTEGER NOT NULL AUTO_INCREMENT,
                    GROUP_NAME VARCHAR (99) NOT NULL,
                    MEDIA_TYPE VARCHAR (99),
                    LANGUAGE VARCHAR (2),
                    COUNTRY VARCHAR (2),
                    PAGE VARCHAR (99),
                    PROFILE BLOB,
    PRIMARY KEY(PSML_ID),
    UNIQUE (GROUP_NAME, MEDIA_TYPE, LANGUAGE, COUNTRY, PAGE)
);

# -----------------------------------------------------------------------
# JETSPEED_ROLE_PROFILE
# -----------------------------------------------------------------------
drop table if exists JETSPEED_ROLE_PROFILE;

CREATE TABLE JETSPEED_ROLE_PROFILE
(
                            PSML_ID INTEGER NOT NULL AUTO_INCREMENT,
                    ROLE_NAME VARCHAR (99) NOT NULL,
                    MEDIA_TYPE VARCHAR (99),
                    LANGUAGE VARCHAR (2),
                    COUNTRY VARCHAR (2),
                    PAGE VARCHAR (99),
                    PROFILE BLOB,
    PRIMARY KEY(PSML_ID),
    UNIQUE (ROLE_NAME, MEDIA_TYPE, LANGUAGE, COUNTRY, PAGE)
);
 

# -----------------------------------------------------------------------
# COFFEES
# -----------------------------------------------------------------------
drop table if exists COFFEES;

CREATE TABLE COFFEES
(
   COFFEE_ID INTEGER NOT NULL AUTO_INCREMENT,
   COFFEE_NAME VARCHAR (50),
   SUPPLIER_ID INTEGER,
   PRICE FLOAT,
   SALES INTEGER,
   TOTAL INTEGER,
   PRIMARY KEY(COFFEE_ID)
);
    
  
  
  
  
