/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.webservices.finance.stockmarket;

import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.*;
import javax.xml.parsers.*;

/**
    SAX-based XML event handler (filter). Works with org.xml.sax.XMLReader to filter
    standard SAX events. This class maps the XML represention of a stock array into a java classes.

    @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
    @version $Id: StockQuoteArrayHandler.java,v 1.1 2001/09/23 08:08:05 taylor Exp $
*/

public class StockQuoteArrayHandler extends XMLFilterImpl
{
    StockQuote[] array = new BaseStockQuote[0];
    StockQuoteHandler currentVal = null;
    boolean inElement;

    public void startElement(String uri, String localName, String qName, Attributes attributes) 
        throws SAXException 
    {
        if (attributes.getValue("href") != null) 
            throw new SAXNotSupportedException("href attributes not supported");
        inElement = true;
        currentVal = new StockQuoteHandler();
        currentVal.setParent(this);
        setContentHandler(currentVal);
    }

    public void endElement(String uri, String localName, String qName) 
        throws SAXException 
    {
        if (inElement) 
        {
            inElement = false;
            StockQuote theVal = currentVal.getResult();
            StockQuote[] newar = new BaseStockQuote[array.length+1];
            System.arraycopy(array,0,newar,0,array.length);
            newar[array.length] = theVal;
            array = newar;
        } else 
        {
            ContentHandler handler = (ContentHandler)getParent();
            getParent().setContentHandler(handler);
            handler.endElement(uri,localName,qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException 
    {
    }

    public StockQuote[] getResult() 
    {
        return array;
    }

    public void setContentHandler(ContentHandler handler) 
    {
        ((XMLReader)getParent()).setContentHandler(handler);
    }

}

