/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.webservices.finance.stockmarket;

import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.*;
import javax.xml.parsers.*;


class SOAPResponseHandler extends XMLFilterImpl 
{
    String outputNameSpace = null;
    String outputElementName = null;
    String outputPartElementName = null;

    public SOAPResponseHandler(String ns, String en, String pen) {
        outputNameSpace = ns;
        outputElementName = en;
        outputPartElementName = pen;
    }

    boolean inSoapEnv = false;
    boolean inSoapBody = false;
    boolean inOperation = false;
    boolean inResult = false;
    boolean debugParse = false;

    StringBuffer resultBuffer = null;
    XMLFilterImpl resultHandler = null;
    int resultElementStack = 0;

    boolean wasFault = false;
    boolean inFault = false;
    boolean inFaultString = false;
    StringBuffer faultContent = null;

    public void setContentHandler(ContentHandler handler) {
        ((XMLReader)getParent()).setContentHandler(handler);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String uriName = uri+":"+localName;
        if ("http://schemas.xmlsoap.org/soap/envelope/:Fault".equals(uriName)) {
            if (debugParse) System.out.println("Found Fault");
            inFault = true;
        } else if (inFault && "faultstring".equals(localName)) {
            if (debugParse) System.out.println("Found Fault String");
            inFaultString = true;
            faultContent = new StringBuffer();
        } else if ("http://schemas.xmlsoap.org/soap/envelope/:Envelope".equals(uriName)) {
            if (debugParse) System.out.println("Found Envelope");
            inSoapEnv = true;
        } else if (inSoapEnv && "http://schemas.xmlsoap.org/soap/envelope/:Body".equals(uriName)) {
            if (debugParse) System.out.println("Found Body");
            inSoapBody = true;
        } else if (inSoapBody && (outputNameSpace+":"+outputElementName).equals(uriName)) {
            if (debugParse) System.out.println("Found operation: "+localName);
            inOperation = true;
        } else if (inOperation && outputPartElementName.equals(localName)) {
            if (attributes.getValue("href") != null) throw new SAXNotSupportedException("href attributes not supported");
            if (debugParse) System.out.println("Found Part: "+localName);
            if (resultHandler != null) {
                resultHandler.setParent(this);
                getParent().setContentHandler(resultHandler);
            } else {
                resultBuffer = new StringBuffer();
            }
            inResult = true;
        } else if (!inFault) {
            if (debugParse) System.out.println("Found Unknown Element: <"+qName+">    ns:"+uri);
            inResult = false;
            inSoapEnv = false;
            inSoapBody = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (inResult && outputPartElementName.equals(localName)) {
            inResult = false;
        } else if ("http://schemas.xmlsoap.org/soap/envelope/:Fault".equals(uri+":"+localName)) {
            wasFault = true;
            inFault = false;
        } else if (inFault && "faultstring".equals(localName)) {
            inFaultString = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (inResult) {
            resultBuffer.append(new String(ch,start,length));
        }
        if (inFault) faultContent.append(new String(ch,start,length));
    }
    public String getResult() {
        if (resultBuffer == null) return null;
        return resultBuffer.toString();
    }
    public void setResultHandler(XMLFilterImpl handler) {
        resultHandler = handler;
    }
    public boolean isFault() {
        return wasFault;
    }
    public String getFaultContent() {
        if (faultContent == null) return "";
        return faultContent.toString();
    }
}
