/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.template;

// Java imports

// ECS imports
import org.apache.ecs.ConcreteElement;

// Junit imports
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;

// Cactus imports
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;

// Jetspeed imports
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.test.TurbineTestUtilities;

// Turbine imports
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;

// Velocity
import org.apache.velocity.context.Context;
/**
 * TestJespeedLink
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: TestJetspeedLink.java,v 1.8 2002/11/23 09:56:13 paulsp Exp $
 */
public class TestJetspeedLink extends ServletTestCase
{
    private static String TEST_CONTEXT = "/test";
    private static String TEST_HOST = "localhost";
    private static String TEST_SERVLET = "/portal";
    
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestJetspeedLink(String name)
    {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        TestRunner.main( new String[] { TestJetspeedLink.class.getName() } );
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestJetspeedLink.class );
    }
    
    
    public void beginBaseLink(WebRequest theRequest)
    {
        System.out.println("URL = " + theRequest.getURL());
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET, "", null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the base link
     * @throws Exception
     */
    public void testBaseLink() throws Exception
    {
        ProfileLocator profileLocator = null;

        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
                
        // Generate the link
        String link = jsLink.toString();
        System.out.println("Base link = " + link);
        assertTrue( "Verifing base Link", 
          link.startsWith("http://" + TEST_HOST + TEST_CONTEXT + TEST_SERVLET));

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }
    
    public void endBaseLink(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text length = " + theResponse.getText().length());
    }
    
    public void beginGroupLink(WebRequest theRequest)
    {
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET
        , "/" + Profiler.PARAM_GROUP + "/apache" , null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the Group link
     * @throws Exception
     */
    public void testGroupLink() throws Exception
    {
        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
        
        // Generate the link
        String link = jsLink.toString();
        System.out.println("Group link = " + link);
        assertTrue( "Verifing base Link", 
          link.startsWith("http://" + TEST_HOST + TEST_CONTEXT + TEST_SERVLET));

        assertTrue( "Verify link contains /" + Profiler.PARAM_GROUP + "/apache", 
          (link.indexOf("/" + Profiler.PARAM_GROUP + "/apache") >0));

        assertEquals( "Verify link does NOT contain /" + Profiler.PARAM_USER, -1,
           link.indexOf("/" + Profiler.PARAM_USER ));

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
        
    }
    
    public void endGroupLink(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text = " + theResponse.getText().length());
    }
    
    public void beginPageLink(WebRequest theRequest)
    {
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET
        , "/" + Profiler.PARAM_PAGE + "/news" , null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the User link
     * @throws Exception
     */
    public void testPageLink() throws Exception
    {
        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
        
        // Generate the link
        String link = jsLink.toString();
        System.out.println("Page Link = " + link);
        assertTrue( "Verifing base Link", 
          link.startsWith("http://" + TEST_HOST + TEST_CONTEXT + TEST_SERVLET));

        assertTrue( "Verify link contains /" + Profiler.PARAM_USER + "/anon", 
          (link.indexOf("/" + Profiler.PARAM_USER + "/anon") >0));

        assertTrue( "Verify link contains /" + Profiler.PARAM_PAGE + "/news", 
          (link.indexOf("/" + Profiler.PARAM_PAGE + "/news") >0));

        assertEquals( "Verify link does NOT contain /" + Profiler.PARAM_GROUP, -1,
           link.indexOf("/" + Profiler.PARAM_GROUP ));

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }
    public void endPageLink(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text = " + theResponse.getText().length());
    }
    
    public void beginGroupPage(WebRequest theRequest)
    {
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET
        , "/" + Profiler.PARAM_GROUP + "/apache/" + Profiler.PARAM_PAGE + "/news" , null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the User link
     * @throws Exception
     */
    public void testGroupPage() throws Exception
    {
        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
        
        // Generate the link
        String link = jsLink.toString();
        System.out.println("Group/Page Link = " + link);
        assertTrue( "Verifing base Link", 
          link.startsWith("http://" + TEST_HOST + TEST_CONTEXT + TEST_SERVLET));

        assertTrue( "Verify link contains /" + Profiler.PARAM_GROUP + "/apache", 
          (link.indexOf("/" + Profiler.PARAM_GROUP + "/apache") >0));

        assertEquals( "Verify link does NOT contain /" + Profiler.PARAM_USER, -1,
           link.indexOf("/" + Profiler.PARAM_USER ));

        assertTrue( "Verify link contains /" + Profiler.PARAM_PAGE + "/news", 
          (link.indexOf("/" + Profiler.PARAM_PAGE + "/news") >0));
        
        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }
    public void endGroupPage(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text = " + theResponse.getText().length());
    }

    public void beginGroupPage2(WebRequest theRequest)
    {
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET
        , "/" + Profiler.PARAM_GROUP + "/apache/" + Profiler.PARAM_PAGE + "/news" , null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the User link
     * @throws Exception
     */
    public void testGroupPage2() throws Exception
    {
        JetspeedLink jetspeedLink = null;
        
        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
        
        // Generate the link
        String link = jsLink.toString();
        System.out.println("Group/Page Link = " + link);
        
        // Generate the link from JetspeedLink
        jetspeedLink = JetspeedLinkFactory.getInstance(rundata);
        System.out.println("Group/Page jetspeedLink = " + jetspeedLink.toString());
        assertEquals( "jsLink = jetspeedLink", link, jetspeedLink.toString());
        JetspeedLinkFactory.putInstance(jsLink);
        
        // Make sure 2 calls to toString() return the same value
        jetspeedLink = JetspeedLinkFactory.getInstance(rundata);
        assertEquals( "jsLink = jetspeedLink", jetspeedLink.toString(), jetspeedLink.toString());
        JetspeedLinkFactory.putInstance(jsLink);

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }
    public void endGroupPage2(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text = " + theResponse.getText().length());
    }
    
    
    public void beginGetLink(WebRequest theRequest)
    {
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET
        , "/" + Profiler.PARAM_GROUP + "/apache/" + Profiler.PARAM_PAGE + "/news/" + JetspeedResources.PATH_PORTLETID_KEY + "/p_1234/" + JetspeedResources.PATH_TEMPLATE_KEY + "/Home/" + Profiler.PARAM_MEDIA_TYPE + "/html/" + Profiler.PARAM_LANGUAGE + "/en/" + Profiler.PARAM_COUNTRY + "/US" , null);
        System.out.println("post set URL = " + theRequest.getURL());
    }
    
    /**
     * Test the User link
     * @throws Exception
     */
    public void testGetLink() throws Exception
    {
        JetspeedLink jetspeedLink = null;
        
        // Create the RunData object to be used during testing.
        RunData rundata = RunDataFactory.getRunData( request, response, config );
        assertNotNull( "Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);
        
        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull( "Got context", context);
        TurbinePull.populateContext( context, rundata);
        
        // Verify tool are in the context
        JetspeedLink jsLink = (JetspeedLink) context.get("jslink");
        assertNotNull( "Got jslink from context", jsLink);
        
        // Generate the link from JetspeedLink
        jetspeedLink = JetspeedLinkFactory.getInstance(rundata);
        String baseLink = new String("http://" + TEST_HOST + TEST_CONTEXT + TEST_SERVLET);
        String currentLink = new String( baseLink 
            + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType() 
            + "/" + Profiler.PARAM_GROUP + "/" + jetspeedLink.getGroupName() 
            + "/" + Profiler.PARAM_PAGE + "/" + jetspeedLink.getPageName());
 
        assertEquals( "Testing getGroupName()", "apache" , jetspeedLink.getGroupName() );
        assertEquals( "Testing getPageName()", "news.psml" , jetspeedLink.getPageName() );
        assertEquals( "Testing getPageName()", "html" , jetspeedLink.getMediaType() );
        assertNull( "Testing getRoleName()", jetspeedLink.getRoleName() );
        assertNull( "Testing getUserName()", jetspeedLink.getUserName() );

        // Test conveniance methods
        assertEquals( "Testing getAction(actionName)", currentLink + "?" + JetspeedResources.PATH_ACTION_KEY + "=myAction", jetspeedLink.getAction("myAction").toString());
        assertEquals( "Testing getAction(actionName, peid)", currentLink + "/" + JetspeedResources.PATH_PORTLETID_KEY + "/actionpeid?" + JetspeedResources.PATH_ACTION_KEY + "=myAction1", jetspeedLink.getAction("myAction1","actionpeid").toString() );
        assertEquals( "Testing getGroup(groupName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType()+ "/" + Profiler.PARAM_GROUP + "/myGroup", jetspeedLink.getGroup("myGroup").toString());
        assertEquals( "Testing getGroup(groupName,pageName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType() + "/" + Profiler.PARAM_GROUP + "/myGroup1/" + Profiler.PARAM_PAGE + "/myGroupPage", jetspeedLink.getGroup("myGroup1","myGroupPage").toString());
        assertEquals( "Testing getHomePage()", baseLink , jetspeedLink.getHomePage().toString() );
        assertEquals( "Testing getRole(roleName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType() + "/" + Profiler.PARAM_ROLE + "/myRole", jetspeedLink.getRole("myRole").toString());
        assertEquals( "Testing getRole(roleName,pageName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType()+ "/" + Profiler.PARAM_ROLE + "/myRole1/" + Profiler.PARAM_PAGE + "/myRolePage", jetspeedLink.getRole("myRole1","myRolePage").toString());
        assertEquals( "Testing getTemplate(templateName)", currentLink  + "/" + JetspeedResources.PATH_TEMPLATE_KEY + "/myTemplate", jetspeedLink.getTemplate("myTemplate").toString());
        assertEquals( "Testing getTemplate()", currentLink , jetspeedLink.getTemplate().toString() );
        assertEquals( "Testing getUser(userName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType() + "/" + Profiler.PARAM_USER + "/myUser", jetspeedLink.getUser("myUser").toString());
        assertEquals( "Testing getUser(userName,PageName)", baseLink + "/" + Profiler.PARAM_MEDIA_TYPE + "/" + jetspeedLink.getMediaType() + "/" + Profiler.PARAM_USER + "/myUser1/" + Profiler.PARAM_PAGE + "/myUserPage", jetspeedLink.getUser("myUser1","myUserPage").toString());

        // Test getLink()
        assertEquals( "Testing getLink() with default & nulls",
            baseLink + 
            "/" + Profiler.PARAM_MEDIA_TYPE +
            "/" + jetspeedLink.getMediaType() + 
            "/" + Profiler.PARAM_PAGE + 
            "/" + jetspeedLink.getPageName(),
            jetspeedLink.getLink(JetspeedLink.DEFAULT, null, null, JetspeedLink.DEFAULT, null, null).toString() );

        assertEquals( "Testing getLink() with current & nulls", 
            baseLink + 
            "/" + Profiler.PARAM_MEDIA_TYPE + 
            "/" + jetspeedLink.getMediaType()  + 
            "/" + Profiler.PARAM_GROUP + 
            "/" + jetspeedLink.getGroupName()+ 
            "/" + Profiler.PARAM_PAGE + 
            "/" + jetspeedLink.getPageName(),
            jetspeedLink.getLink(JetspeedLink.CURRENT, null, null, JetspeedLink.CURRENT, null, null).toString() );

        assertEquals( "Testing getLink() with default & nulls + media/language/country", 
            baseLink + 
            "/" + Profiler.PARAM_PAGE + 
            "/" + jetspeedLink.getPageName() + 
            "/" + Profiler.PARAM_MEDIA_TYPE + 
            "/" + "test_html"+ 
            "/" + Profiler.PARAM_LANGUAGE + 
            "/" + "test_en" + 
            "/" + Profiler.PARAM_COUNTRY + 
            "/" + "test_US", 
            jetspeedLink.getLink(JetspeedLink.DEFAULT, null, null, JetspeedLink.DEFAULT, null, null, null, "test_html", "test_en", "test_US").toString() );

        JetspeedLinkFactory.putInstance(jsLink);
        
        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        TurbineTestUtilities.outputPage(rundata);
        
        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }
    public void endGetLink(org.apache.cactus.WebResponse theResponse)
    {
        System.out.println("text = " + theResponse.getText().length());
    }
}
