/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.template;

import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.template.TemplateLink;
import org.apache.turbine.services.pull.ApplicationTool;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.services.rundata.JetspeedRunData;


/**
 * A customized version of the JetspeedTemplateLink that reacts to the 
 * Portlet context and allows you to manipulate the lowest level pane 
 * if it exists.
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @deprecated Since 2002-03-05. Use JetspeedTemplateLink with the setPortlet(Portlet) method to give
 * it the right context.
 * @version $Id: PortletTemplateLink.java,v 1.2 2002/03/05 12:26:33 sgala Exp $
 */
public class PortletTemplateLink extends JetspeedTemplateLink
{
        
    private Portlet portlet = null;
    private JetspeedRunData data = null;
    
    /**
     * Empty constructor.for introspection
     */
    public PortletTemplateLink()
    {
    }

    /**
     * Constructor.
     *
     * @param data A Turbine RunData object.
     */
    public PortletTemplateLink(RunData data, Portlet portlet)
    {
        super(data);
        this.portlet = portlet;
    }

    /** 
     * Add a select-panel reference in the link
     *
     * @param portlet the name of the portlet to link to
     * @return a self reference for easy link construction in template
     */
    public DynamicURI setPanel(String panel)
    {
        removePathInfo(getPanelKey());
        removeQueryData(getPanelKey());
        return addPathInfo(getPanelKey(), panel);
    }
    
     /** 
     * @return the panel parameter name
     */
    public String getPanelKey()
    {
        String panelName = PANEL_KEY;
        try
        {
            PortletController controller = portlet.getPortletConfig()
                                                  .getPortletSet()
                                                  .getController();

            if (controller instanceof PanedPortletController)
            {
                panelName=((PanedPortletController)controller).getParameterName();
            }
            
        }
        catch (Exception e)
        {
            panelName = PANEL_KEY;
        }
        
        return panelName;
    }    
}
