/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util.rewriter;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.Assert;
 
import java.io.Reader;
import java.io.StringReader;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import java.net.URL;
import java.net.URLConnection;

import org.apache.jetspeed.util.Streams;


public class TestRewriter // extends TestCase 
{
    /*
    static public Test suite()
    {
        TestSuite suite = new TestSuite(TestRewriter.class);
        return(suite);
    }
      */
    public TestRewriter(String name)
    {
        //super(name);
    }

    ///////////////////////////////////////////////////////////////////////////
            

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }


    ///////////////////////////////////////////////////////////////////////////

    public void testPage()
    {
        Reader reader = null;

        try 
        {
            String baseURL = "http://java.sun.com/";
            String fullURL = "http://java.sun.com/";

            //URL pageUrl = new URL("http://www.devx.com/Java/Article/9747/");
            URL pageUrl = new URL(fullURL);

            URLConnection  pageConn = pageUrl.openConnection();
            String         encoding = pageConn.getContentEncoding();

            if(encoding == null)
            {
                // Standard HTTP encoding
                encoding = "iso-8859-1";
            }

            reader = new InputStreamReader(pageConn.getInputStream(),
                                               encoding );
            
            //String crap = Streams.getAsString(reader);
            //System.out.println("crap = " + crap);
            
            HTMLRewriter rewriter = new HTMLRewriter();

            // String result = rewriter.rewrite(reader, "XXXX", "YYYY");
            String result = rewriter.rewrite(reader, baseURL);
            System.out.println(result);
            
            reader.close();
            reader = null;

        } catch (Exception e) 
        {
            System.err.println("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        finally
        {
            try
            {
                if (null != reader)
                    reader.close();
            }
            catch (Exception e)
            {}
        }
    }

    ///////////////////////////////////////////////////////////////////////////

    static public void main(String[] argv)
    {
        // String[] testCaseName = {TestRewriter.class.getName()};
        // junit.swingui.TestRunner.main(testCaseName);
        TestRewriter trw = new TestRewriter("test");
        trw.testPage();

    }

}

