/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.rewriter;

// java.io
import java.io.IOException;
import java.io.CharArrayWriter;
import java.io.Reader;

// java.net
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;                 

// this makes it dependent on Swing...need an abstraction WTP
import javax.swing.text.html.HTML;
import javax.swing.text.MutableAttributeSet;
 
/**
 *                  
 * Basic Rewriter for rewriting HTML content. 
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: HTMLRewriter.java,v 1.3 2002/10/29 18:38:06 taylor Exp $
 * 
 */

public class HTMLRewriter implements Rewriter
{
    /*
     * Construct a basic HTML Rewriter
     *
     */
    public HTMLRewriter()
    {
    }

    protected String baseURL = null;

    /*    
     * This callback is called by the HTMLParserAdaptor implementation to write
     * back all rewritten URLs to point to the proxy server.
     * Given the targetURL, rewrites the link as a link back to the proxy server.
     *
     * @return the rewritten URL to the proxy server.
     *
     */
    public String generateNewUrl( String targetURL, HTML.Tag tag, HTML.Attribute attribute)
    {
        String fullPath = "";
        try
        {

            if (baseURL != null)
            {
                URL full = new URL(new URL(baseURL), targetURL);
                fullPath = full.toString();
            }
            else
            {
                return targetURL; // leave as is
            }
        }
        catch (Exception e)
        {
            System.err.println(e);
        }
        return fullPath;

    }

    
    /*
     * Returns true if all rewritten URLs should be sent back to the proxy server.
     *
     * @return true if all URLs are rewritten back to proxy server.
     */
    public boolean proxyAllTags()
    {
        return true; //false;
    }

    public String rewrite(Reader input, String baseURL)
                               throws MalformedURLException
    {
        String rewrittenHTML = "";
        this.baseURL = baseURL;

        HTMLParserAdaptor parser = new SwingParserAdaptor(this);
        rewrittenHTML = parser.run(input);

        return rewrittenHTML;
    }

    /*
     * Simple Tag Events
     */
    public boolean enterSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs)
    {
        return true;
    }

    public String exitSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs)
    {
        return null;
    }

    /*
     * Start Tag Events
     */
    public boolean enterStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs)
    {
        return true;
    }

    public String exitStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs)
    {
        return null;
    }

    /*
     * Exit Tag Events
     */
    public boolean enterEndTagEvent(HTML.Tag tag)
    {
        return true;
    }

    public String exitEndTagEvent(HTML.Tag tag)
    {
        return null;
    }


    /*
     * Convert Tag Events
     */
    public void convertTagEvent(HTML.Tag tag, MutableAttributeSet attrs)
    {
    }

}

