package org.apache.jetspeed.util.parser;

import javax.servlet.http.HttpServletRequest;

import org.apache.turbine.util.Log;
import org.apache.turbine.util.parser.DefaultParameterParser;

import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class DefaultJetspeedParameterParser extends DefaultParameterParser {

    /**
     * Sets the servlet request to be parser.  This requires a
     * valid HttpServletRequest object.  It will attempt to parse out
     * the GET/POST/PATH_INFO data and store the data into a Hashtable.
     * There are convenience methods for retrieving the data as a
     * number of different datatypes.  The PATH_INFO data must be a
     * URLEncoded() string.
     *
     * <p>To add name/value pairs to this set of parameters, use the
     * <code>add()</code> methods.
     *
     * @param req An HttpServletRequest.
     */
    public void setRequest(HttpServletRequest req)
    {
        super.setRequest(req);

        String enc = JetspeedResources.getString(JetspeedResources.CONTENT_ENCODING_KEY,"US-ASCII");
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap( req.getHeader("User-Agent") );
        Log.info("DefaultJetspeedParameterParser: req.getHeader(\"User-Agent\"): " + req.getHeader("User-Agent"));
        String mimeCode = cm.getPreferredType().getCode();
        Log.info("DefaultJetspeedParameterParser: mimeCode: " + mimeCode );
        if ( mimeCode != null )
        {
            MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, mimeCode);
            if ( media != null && media.getCharacterSet() != null)
            {
                enc = media.getCharacterSet();
                Log.info("DefaultJetspeedParameterParser: media.getCharacterSet(): " + media.getCharacterSet() );
            }

        }
        if ( req.getCharacterEncoding() != null )
        {
            enc = req.getCharacterEncoding();
            Log.info("DefaultJetspeedParameterParser: req.getCharacterEncoding(): " + req.getCharacterEncoding() );
        }
        Log.info("DefaultJetspeedParameterParser: enc: " + enc );
        setCharacterEncoding( enc );
    }

    /**
     * Return a String for the given name.  If the name does not
     * exist, return null.
     *
     * @param name A String with the name.
     * @return A String.
     */
    public String getString(String name)
    {
        String str = super.getString(name);
        if (str == null) return null;

        Log.info("DefaultJetspeedParameterParser: getCharacterEncoding(): " + getCharacterEncoding());
        try
        {
            return new String(str.getBytes("8859_1"), getCharacterEncoding());
        }
        catch (Exception e)
        {
            Log.info("DefaultJetspeedParameterParser: Exception: " + e.toString());
            return str;
        }

    }

}

