/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.security;

import java.util.Iterator;

import org.apache.turbine.services.Service;

import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.services.security.JetspeedSecurityException;

/**
 * The Security Cache Service caches roles and permissions (ACLs)
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: SecurityCacheService.java,v 1.5 2002/12/08 19:33:53 taylor Exp $
 */


public interface SecurityCacheService extends Service
{
   /** The name of this service */
   public String SERVICE_NAME = "SecurityCache";

   /*
    * Loads the security cache for the given user.
    *
    * @param username the user to cache all role and permission information for.
    */
    public void load(String username)
        throws JetspeedSecurityException;

    /*
     * UnLoads the security cache for the given user.
     *
     * @param username the user to cache all role and permission information for.
     */
    public void unload(String username);


    public void loadRolePermissions();

    /**
     *  Retrieves a role from the cache for the given username.
     *
     * @param username The name key of the user.
     * @param roleName The name of the role.
     */ 
    public Role getRole(String username, String roleName);
    
    /**
     *  Retrieves a role from the cache for the given username.
     *
     */ 
    public void addRole(Role role);

    public void addRole(String username, Role role);

    public boolean hasRole(String username, String roleName);

    public void removeRole(String username, String roleName);

    public Iterator getRoles(String username);

    public CachedAcl getAcl(String username);

    public Permission getPermission(String roleName, String permissionName);
    
    public void addPermission(String roleName, Permission permission);

    public boolean hasPermission(String roleName, String permissionName);

    public void removePermission(String roleName, String permissionName);

    public Iterator getPermissions(String roleName);

    public void removeAllRoles(String rolename);

    public void removeAllPermissions(String permissionName);

}



