package org.apache.jetspeed.services.jsp.tags;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import java.util.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

// Turbine Classes
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.services.jsp.JspService;

import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.services.Profiler;

/**
 * Supporting class for the portlet tag.
 * Builds the output of a portlet (with conrol) and insert it within the
 * current JSP page
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: JetspeedPortletTag.java,v 1.6 2002/11/08 10:05:18 raphael Exp $
 */
public class JetspeedPortletTag extends TagSupport
{
    private String name = null;
    private String psml = null;

    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return this.name;
    }

    public void setPsml(String psml)
    {
        this.psml = psml;
    }

    public String getPsml()
    {
        return this.psml;
    }

    /**
     * Method called when the tag is encountered to send attributes to the
     * output stream
     *
     * @return SKIP_BODY, as it is intended to be a single tag.
     */
    public int doStartTag() throws JspException
    {
        JetspeedRunData data = (JetspeedRunData)pageContext.getAttribute(JspService.RUNDATA, PageContext.REQUEST_SCOPE);

        // if called without arguments, use the default request parameter
        if (this.name == null)
        {
            this.name = data.getPortlet();
        }

        try
        {
            pageContext.getOut().flush();

            ConcreteElement result = new ConcreteElement();
            Entry entry = null;

            if (this.psml != null)
            {
               ProfileLocator baseLocator = Profiler.createLocator();
               baseLocator.createFromPath(this.psml);
               Profile baseProfile = Profiler.getProfile(baseLocator);
               if (baseProfile != null)
               {
                   entry = baseProfile.getDocument().getEntry(name);
                   Log.debug("JetspeedPortletTag: retrieved [" + entry + "] from psml [" + this.psml);
               }
            }
            else
            {
               entry  = data.getProfile().getDocument().getEntry(name);
               Log.debug("JetspeedPortletTag: retrieved [" + entry + "] from current psml");
            }

            if (entry != null)
            {
                result = PortletFactory.getPortlet(entry).getContent(data);
            }

            // Check whether this is an "old" screen (that returns a ConcreteElement)
            // or a "new" one that returns null.
            if ( result != null )
            {
                //The ECS element must serialize in the character encoding
                // of the response
                result.setCodeSet( data.getResponse().getCharacterEncoding() );

                result.output( data.getResponse().getWriter() );
            }

        }
        catch (Exception e)
        {
            String message = "Error processing name '" + name + "'.";
            Log.error(message, e);
            try
            {
                data.getOut().print("Error processing portlet '" + name + "'. See log for more information.");
            }
            catch(java.io.IOException ioe) {}
        }
        return SKIP_BODY;
    }
}
