package org.apache.jetspeed.services.jsp.tags;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Java classes
import java.util.MissingResourceException;

// Servlet API
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

// Turbine Classes
import org.apache.turbine.util.Log;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.localization.Localization;

// ECS support
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

// Jetspeed support
import org.apache.jetspeed.services.rundata.JetspeedRunData;

/**
 * Supporting class for the localization (l10n) tag.
 * Returns a localized text for string specified in the "key" parameter.
 * Use "alt" parameter to specify a default value if "key" is not translated.
 *
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: JetspeedL10NTag.java,v 1.1 2002/11/29 19:26:09 morciuch Exp $
 */
public class JetspeedL10NTag extends TagSupport
{
    private String key = null;
    private String alt = null;

    public void setKey(String value)
    {
        this.key = value;
    }

    public String getKey()
    {
        return this.key;
    }

    public void setAlt(String value)
    {
        this.alt = value;
    }

    public String getAlt()
    {
        return this.alt;
    }

    /**
     * Method called when the tag is encountered to send attributes to the
     * output stream
     *
     * @return SKIP_BODY, as it is intended to be a single tag.
     */
    public int doStartTag() throws JspException
    {
        JetspeedRunData data = (JetspeedRunData) pageContext.getAttribute(JspService.RUNDATA, PageContext.REQUEST_SCOPE);

        try
        {
            ConcreteElement result = null;
            try 
            {
                result = new StringElement(Localization.getString(this.key));            
            }
            catch (MissingResourceException mre)
            {
                if (this.alt != null && this.alt.trim().length() > 0)
                {
                    result = new StringElement(this.alt);
                }
                else
                {
                    result = new StringElement(this.key);
                }            
            }

            // Output the result
            if (result != null)
            {
                pageContext.getOut().print(result);
            }

        }
        catch (Exception e)
        {
            String message = "Error processing key '" + this.key + "'.";
            Log.error(message, e);
            try
            {
                data.getOut().print("Error translating key '" + this.key + "'. See log for more information.");
            }
            catch (java.io.IOException ioe)
            {
            }
        }
        return EVAL_BODY_INCLUDE;
    }
}
