package org.apache.jetspeed.services.jsp.tags;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import java.util.*;
import java.text.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

// Turbine Classes 
import org.apache.turbine.util.*;
import org.apache.turbine.services.jsp.JspService;


/**
 * Supporting class for the info tag.
 * Sends the screens ecs element's content to the output stream.  
 *
 * @author <a href="mailto:ingo@raleigh.ibm.com">Ingo Schuster</a>
 * @author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
 */
public class InfoTag extends TagSupport 
{
    /**
     * requestedInfo parameter defines type of Info that is being requested
     */
    private String requestedInfo;

    /** 
     * The setter for requestedInfo parameter
     */
    public void setRequestedInfo(String requestedInfo)
    {
        this.requestedInfo = requestedInfo;
    }


    public int doStartTag() throws JspException 
    {
        RunData data = (RunData)pageContext.getAttribute(JspService.RUNDATA, PageContext.REQUEST_SCOPE);    
        
        try
        {           
            String result = "jetspeed-InfoTag: unknown parameter >" + requestedInfo +"<";

            /* Server Date */
            if (requestedInfo.equalsIgnoreCase("ServerDate")) {
                result = DateFormat.getDateTimeInstance().format( new Date());
            }  

            /* User Name */
            if (requestedInfo.equalsIgnoreCase("UserName")) {
              result = data.getUser().getUserName();
            }  

            /* First Name */
            if (requestedInfo.equalsIgnoreCase("FirstName")) {
              result = data.getUser().getFirstName();
            }  

            /* Last Name */
            if (requestedInfo.equalsIgnoreCase("LastName")) {
              result = data.getUser().getLastName();
            }  

            /* EMail */
            if (requestedInfo.equalsIgnoreCase("EMail")) {
              result = data.getUser().getEmail();
            }  
            pageContext.getOut().print(result);
        }
        catch (Exception e)
        {
            String message = "Error processing info-tag, parameter: "+ requestedInfo;
            Log.error(message, e);
            try
            {
                data.getOut().print("Error processing info-tag, parameter: "+ requestedInfo);
            }
            catch(java.io.IOException ioe) {}    
        }
        return EVAL_BODY_INCLUDE;
    }
}
