/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services;

// jetspeed stuff
import org.apache.jetspeed.services.portletstats.PortletStatsService;
import org.apache.jetspeed.portal.Portlet;

// turbine stuff
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;


/**
 * <P>This is a commodity static accessor class around the 
 * <code>PortletStatsService</code></P>
 * 
 * @see org.apache.jetspeed.services.portletstats.PortletStatsService
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: PortletStats.java,v 1.2 2002/09/03 15:01:40 morciuch Exp $
 */
public class PortletStats {
 
    /**
     * Return code when access to portlet was successful
     */
    public static final String ACCESS_OK        = "200";

    /**
     * Return code when access to portlet was denied by the security manager
     */
    public static final String ACCESS_DENIED    = "401";

    /** 
     * Commodity method for getting a reference to the service
     * singleton
     */
    private static PortletStatsService getService() 
    {
        return (PortletStatsService)TurbineServices
                .getInstance()
                .getService(PortletStatsService.SERVICE_NAME);     
    }
    
    /**
     * @see org.apache.jetspeed.services.portletstats.PortletStatsService#isEnabled
     */
    public static boolean isEnabled() 
    {
        return getService().isEnabled();
    }

    /**
     * @see org.apache.jetspeed.services.portletstats.PortletStatsService#setEnabled
     */
    public static boolean setEnabled(boolean state) 
    {
        return getService().setEnabled(state);
    }

    /**
     * @see org.apahce.jetspeed.services.portletstats.PortletStatsService#logAccess
     */
    public static void logAccess(RunData data, Portlet portlet, String statusCode) 
    {
        getService().logAccess(data, portlet, statusCode);
    }
            
}
