/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services;

import org.apache.jetspeed.services.ldap.LDAPService;
import org.apache.jetspeed.services.ldap.LDAPURL;
import org.apache.turbine.services.TurbineServices;
import javax.naming.*;
import javax.naming.directory.*;
import java.util.Vector;


/**
 *
 * @author <a href="mailto:ender@kilicoglu.nom.tr">Ender KILICOGLU</a>
 * @version $Id: JetspeedLDAP.java,v 1.2 2002/12/09 20:24:08 taylor Exp $ 
 * 
 */
public class JetspeedLDAP 
{
    private static LDAPService getService()
    {
        return(LDAPService)TurbineServices
        .getInstance()
        .getService(LDAPService.SERVICE_NAME);
    }

    public static boolean addAttribute(LDAPURL url, Attribute at)
    {
        return getService().addAttribute(url, at);
    }


    public static boolean addEntry(LDAPURL url, Attributes at)
    {
        return getService().addEntry(url, at);
    }

    public static int compare(LDAPURL srcUrl, LDAPURL dstUrl)
    {
        return getService().compare(srcUrl, dstUrl);
    }

    public static boolean deleteAttribute(LDAPURL url, Attribute at)
    {
        return getService().deleteAttribute(url, at);
    }

    public static boolean deleteEntry(LDAPURL url)
    {
        return getService().deleteEntry(url);
    }

    public static LDAPURL buildURL(String DN)
    {
        return getService().buildURL(DN);
    }

    public static boolean deleteTree(LDAPURL url)
    {
        return getService().deleteTree(url);
    }

    public static boolean exists(LDAPURL url)
    {
        return getService().exists(url);
    }

    public static LDAPURL findEntryName(LDAPURL url)
    {
        return getService().findEntryName(url);
    }

    public static String removeAttrName(String attrvalue)
    {
        return getService().removeAttrName(attrvalue);
    }

    public static Attributes read(LDAPURL url)
    {
        return getService().read(url);
    }

    public static boolean renameEntry(LDAPURL url, String newDN)
    {
        return getService().renameEntry(url, newDN);
    }

    public static Vector search(LDAPURL url, String filter, String attribs[], boolean subTreeScope)
    {
        return getService().search(url, filter, attribs, subTreeScope);
    }

    public static boolean synchEntry(LDAPURL url, Attributes ats)
    {
        return getService().synchEntry(url, ats);
    }

    public static boolean deleteAttrs(LDAPURL url, Attributes ats)
    {
        return getService().deleteAttrs(url, ats);
    }

    public static boolean transfer(LDAPURL fromUrl, LDAPURL toUrl, boolean delete, boolean replace, boolean withChildren)
    {
        return getService().transfer(fromUrl, toUrl, delete, replace, withChildren);
    }

    public static boolean transferEntry(LDAPURL fromUrl, Attributes ats, LDAPURL toUrl, boolean delete, boolean replace)
    {
        return getService().transferEntry(fromUrl, ats, toUrl, delete, replace);
    }

    public static boolean transferEntry(LDAPURL fromUrl, LDAPURL toUrl, boolean delete, boolean replace)
    {
        return getService().transferEntry(fromUrl, toUrl, delete, replace);
    }

    public static boolean updateAttribute(LDAPURL url, Attribute at)
    {
        return getService().updateAttribute(url, at);
    }

    public static boolean updateEntry(LDAPURL url, Attributes at)
    {
        return getService().updateEntry(url, at);
    }

    public static boolean updateEntry(LDAPURL url, Attributes ats, boolean replace)
    {
        return getService().updateEntry(url, ats, replace);
    }

    public static String getName(String dn)
    {
        return getService().getName(dn);
    }
}
