package org.apache.jetspeed.portal.portlets.language;
/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * @author Dess Massimiliano
 * desmax74@yahoo.it
 * massimiliano.dessi@gruppoatlantis.it
 * massimiliano.dessi@gruppoatlantis.com
 * version 1.0  10-2002
 * jdk 1.4.1
 */
 
 
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.velocity.context.Context;
import org.apache.jetspeed.util.template.BaseJetspeedLink;

public class ConstructorHtml {


  public ConstructorHtml(){
  }
  public String getHtml(RunData data,String language, String requestLanguage){

    return constructorContent(data , language, requestLanguage);
  }

  private String constructorContent(RunData data, String linguaAttuale, String linguaRichiesta) {

       String linkCurrentPage = this.createLinkCurrentPage(data);

       String html = "<body bgcolor=\"#FFFFFF\" text=\"#000000\">" +
               "<a href=" + linkCurrentPage + "?cL=it>IT</a> " +
               "<a href=" + linkCurrentPage + "?cL=en>EN</a> " +
               "<a href=" + linkCurrentPage + "?cL=es>ES</a> " +
               "<a href=" + linkCurrentPage + "?cL=de>DE</a> " +
               "<a href=" + linkCurrentPage + "?cL=fr>FR</a> " +
               "<a href=" + linkCurrentPage + "?cL=no>NO</a> " +
               "<a href=" + linkCurrentPage + "?cL=ja>JA</a> " +
               "</body></html>";

     /*  to enable icon flag uncomment this put the gif in jetspeed\images\ and comment the previous*/
       /*String html="<body bgcolor=\"#FFFFFF\" text=\"#000000\">"+
                  "<a href=" + linkCurrentPage + "?cL=en><img src=\"images/ic-en.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "<a href=" + linkCurrentPage + "?cL=it><img src=\"images/ic-it.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "<a href=" + linkCurrentPage + "?cL=fr><img src=\"images/ic-fr.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "<a href=" + linkCurrentPage + "?cL=de><img src=\"images/ic-de.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "<a href=" + linkCurrentPage + "?cL=es><img src=\"images/ic-es.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "<a href=" + linkCurrentPage + "?cL=ja><img src=\"images/ic_ja.gif\" width=\"38\" height=\"38\" border=\"0\"></a>  "+
                  "</body></html>";*/

       return html;
   }

   private String createLinkCurrentPage(RunData data) {
        Context context = TurbineVelocity.getContext(data);
        Object jslink = context.get("jslink");
        String idPane = data.getParameters().getString("js_pane");
        String linkPage = ((BaseJetspeedLink) jslink).getPaneById("Page").toString();
        int lenght = linkPage.length();
        String linkCurrentPage = linkPage.substring(0, lenght - 4) + idPane;
        data.setRedirectURI(linkCurrentPage);
        return linkCurrentPage;
    }

}