/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets.browser;

import java.util.Iterator;
import java.util.List;
import java.util.Comparator;
import java.io.Serializable;
/**
 * Browser Iterator Interface
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: BrowserIterator.java,v 1.6 2002/09/24 21:33:36 taylor Exp $
 *
*/
public interface BrowserIterator extends Iterator, Comparator, Serializable
{

    /**
     * This method returns the index of the row to which the cursor is pointing at.
     *
     */
    public int getTop();
    /**
     * This method returns the window size.
     *
     */
    public int getWindowSize();
    /**
     * This method returns the last index of the row in the window displayed.
     *
     */
    public int getBottom();

    /**
     * This method points the cursor to the index provided.
     *
     * @param start Index to which cursor should point to
     */
    public void setTop(int start);

    /**
     * This method returns the result set vector.
     *
     */
    public List getResultSet();

    /**
     * This method returns the number of rows in the result set.
     *
     */
    public int getResultSetSize();

    /**
     * This method returns the List containg the column labels of the result set.
     *
     */
    public List getResultSetTitleList();

    /**
     * This method returns the List containg the Types of the columns the result set.
     *
     *@see java.sql.Types
     */
    public List getResultSetTypesList();

    /**
     * This method sorts the result set according to the value of the column as
     * specified by the parameter column name.
     * Changes the order of the result set vector. If it is called on the same
     * columnName more than once it toggles the ordering ie first it will be
     * ascending, then it will be descending, then ascending and so on.
     *
     *@param String sortColumnName
     */
    public void sort(String sortColumnName);

}
