/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

//standard java stuff
import java.io.*;
import java.util.*;
import java.net.*;

//Element Construction Set
import org.apache.ecs.html.*;
import org.apache.ecs.xml.*;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;

//standard Jetspeed stuff
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.util.*;

//turbine stuff
import org.apache.turbine.util.*;
import org.apache.turbine.modules.*;
import org.apache.turbine.services.resources.TurbineResources;

/**
 This portlet will attempt to render the Turbine Screen within a portlet.
 Parameters are passed to the screen via portlet config information:
 <PRE>

 <entry type="abstract" name="TurbineScreen">
     <classname>portlets.TurbineScreenPortlet</classname>
 </entry>

 <entry type="ref" parent="TurbineScreen" name="TestPortal">
     <parameter name="display.screen" value="TurbineScreenName" />
     <parameter name="TurbineScreenName.param.MYPARAM" value="MYVALUE" />
     <metainfo>
          <title>Place title here</title>
          <description>Place description here</description>
     </metainfo>
 </entry>

 </PRE>

 In the above example, the parameter MYPARAM=MYVALUE will be set in the rundata that calls the screen.

@author <a href="mailto:ekkerbj@netscape.net">Jeff Breckke</a>
@version $Id: TurbineScreenPortlet.java,v 1.9 2002/06/28 05:37:32 taylor Exp $
*/
public class TurbineScreenPortlet extends AbstractPortlet
{
    private String screen = null;
    private String bgcolor = null;
    private String classes = null;
    private Hashtable paramSet = null;

    static final public String BGCOLOR = "bgcolor";
    static final public String CLASSES = "classes";
    static final public String SCREEN = "display.screen";

    /**
    */
    public ConcreteElement getContent( RunData rundata )
    {
        ElementContainer content = new ElementContainer();
        try
        {
            rundata = setParams( rundata );
            content.addElement( new Comment( "BEGIN TurbineScreenPortlet" ) );
            content.addElement( ScreenLoader.getInstance().eval( rundata, screen ) );
            content.addElement( new Comment( "END TurbineScreenPortlet" ) );
        }
        catch ( Exception e )
        {
            String message = "TurbineScreenPortlet: " + e.getMessage();
            Log.error( message, e );
            content.addElement( message );
        }
        return ( content );
    }

    /**
    */
    public void init() throws PortletException
    {
        PortletConfig pc = getPortletConfig();
        ConcreteElement myContent = null;
        try
        {
            screen = ( String ) pc.getInitParameter( SCREEN );
            //if it is null here it should be in the parameters
            if ( screen == null )
            {
                throw new IllegalArgumentException("Missing screen parameter");
            }

            //if it is still null something is wrong
            if ( screen == null )
            {
                throw new PortletException( "You need to specify a " + SCREEN + " parameter for this portlet" );
            }

            /* Save the parameters if any */
            String param = null;
            String value = null;
            java.util.Map dict = pc.getInitParameters();
            Iterator en = dict.keySet().iterator();
            int index = -1;
            String tParam = screen + ".param";
            String newParam = null;
            paramSet = new Hashtable();
            while ( en.hasNext() )
            {
                param = ( String ) en.next();
                index = param.indexOf( tParam );
                if ( index != -1 )
                {
                    value = ( String ) dict.get( param );
                    if ( value == null )
                    {
                        throw new PortletException( "Could not retrieve value for " + param );
                    }
                    newParam = param.substring( index + tParam.length() + 1 );
                    paramSet.put( newParam, value );
                }
            }

            bgcolor = this.getPortletConfig().getPortletSkin().getBackgroundColor();
            classes = "WEB-INF/classes";
        }
        catch ( Exception e )
        {
            String message = "TurbineScreenPortlet: " + e.getMessage();
            Log.error( message, e );
        }
    }

    /**
    */
    public boolean getAllowEdit( RunData rundata )
    {
        return false;
    }

    /**
    */
    public boolean getAllowMaximize( RunData rundata )
    {
        return true;
    }

    /**
    */
    private RunData setParams( RunData data )
    {
        data.getParameters().add( BGCOLOR, bgcolor );
        data.getParameters().add( CLASSES, classes );

        Enumeration en = paramSet.keys();
        String param = null;
        while ( en.hasMoreElements() )
        {
            param = ( String ) en.nextElement();
            data.getParameters().add( param, ( String ) paramSet.get( param ) );
        }
        return ( data );
    }
}
