/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

//Element Construction Set
import org.apache.ecs.html.*;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;

//Jetspeed stuff
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.util.*;
import org.apache.jetspeed.cache.disk.*;


//turbine
import org.apache.turbine.util.*;
import org.apache.jetspeed.services.resources.JetspeedResources;

//ecs stuff
import org.apache.ecs.*;
import org.apache.ecs.html.*;

//XML stuff
import org.xml.sax.SAXException;

//java stuff
import java.io.*;


/**
Provides a content publication system (like Slashdot).

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: JetspeedContent.java,v 1.22 2002/09/27 19:54:26 taylor Exp $ 
*/
public class JetspeedContent extends FileWatchPortlet {

    public static final String PROVIDER_NAME_KEY = "provider-name";

    /**
    The name of the JPC provider.
    */
    private String provider = "";

    /**
    The stylesheet for using with this provider
    */
    private String stylesheet = "";

    /**
    The url that was specified by the provider
    */
    private String url = null;
    
    /**
    Return the last time the provider's URL has been changed.
    */
    private long lastModified;
    
    
    /**
    Init this Portlet, set it's title, description, etc.
    */
    public void init() throws PortletException {

        PortletConfig config = this.getPortletConfig();
        
        provider = config.getInitParameter( PROVIDER_NAME_KEY );
        
        if ( provider == null ) {
            throw new PortletException( "You need to specify " + PROVIDER_NAME_KEY );
        }

        //NOTE:  There are no HARD keys here in JetspeedResources.  If you change
        //this format of this it will break at runtime.  CAREFULL!
        
        this.url = JetspeedResources.getString( "content.provider." + provider + ".url" );
        
        this.stylesheet = JetspeedResources.getString( "content.provider." + provider + ".stylesheet.url" );
        
        String title = JetspeedResources.getString( "content.provider." + provider + ".title" );

        String description = JetspeedResources.getString( "content.provider." + provider + ".description" );

        this.setTitle( title );
        this.setDescription( description );
       
        this.setContent( this.parse( url ) );
            
        //now make sure all the above 4 values are define within JetspeedResources
        if ( url == null ||
             stylesheet == null ||
             title == null ||
             description == null ) {
            throw new PortletException( "Not all properties defined in JetspeedResources.  See JetspeedResources.properties notes." );
        }
        
        this.getPortletConfig().setURL( url );
        
        //set the last modification date for this file so that if it is 
        //modified this portlet can be expired from the cache.
        
        try {
            this.lastModified = JetspeedDiskCache.getInstance()
                .getEntry( this.url ).getLastModified();
        } catch ( IOException e ) {
            Log.error( e );
        }
        
    }
    
    /**
    Parse out the JCP URL and return it as a concrete element
    */
    private ConcreteElement parse( String url ) throws PortletException {
 
            
        //now get the url and stylesheet from the JetspeedDiskCache store...

        try {
        
        url = JetspeedDiskCache.getInstance()
            .getEntry( url ).getURL();

        this.stylesheet = JetspeedDiskCache.getInstance()
            .getEntry( this.stylesheet ).getURL();
        } catch (IOException e) {
            Log.error(e);
            throw new PortletException( "Couldn't transform content.  Please see error log" );
        }

        
        try {
            
            return new JetspeedClearElement( SimpleTransform.transform( url, stylesheet ) );
            
        } catch (SAXException e) {
            Log.error( e );
            throw new PortletException( "Couldn't transform content.  Please see error log" );
        }

       
    }
    
}
