/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.om.security.ldap;

import java.util.Hashtable;
import java.util.Vector;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedLDAP;
import org.apache.jetspeed.services.ldap.LDAPURL;

/**
 *
 * @author <a href="mailto:ender@kilicoglu.nom.tr">Ender KILICOGLU</a>
 * @author <a href="mailto:sami.leino@netorek.fi">Sami Leino</a>
 *
 * @version $Id: LDAPGroup.java,v 1.3 2002/12/09 20:24:08 taylor Exp $ 
 * 
 */
public class LDAPGroup extends BaseLDAPObject implements Group {

    // ---------------------------- Constants ----------------------------

    protected static final String OBJECT_CLASS          = "jetspeedgroup";
    protected static final String ORGANIZATIONAL_UNIT   = "ou=groups";

    protected static final String ATTR_GROUP_NAME       = "groupname";
    protected static final String ATTR_GROUP_ID         = "uid";

    // ------------------------- Member variables ------------------------

    protected String name                               = null;
    protected String id                                 = null;
    protected boolean isNew                             = true;

    // --------------------------- Constructors --------------------------

    public LDAPGroup()
    {
        isNew = true;
    }

    public LDAPGroup(String id)
    {
        this.id = id;
        this.name = id;
        isNew = true;
    }

    public LDAPGroup(String name, boolean isNew)
    {
        super.ldapurl = JetspeedLDAP.buildURL(ATTR_GROUP_ID + "=" + name + "," + ORGANIZATIONAL_UNIT);
        this.isNew = isNew;

        if (isNew)
        {
            this.id = name;
            this.name = name;

            super.myAttrs = new BasicAttributes();
            super.myAttrs.put(ATTR_GROUP_ID, name);
            super.myAttrs.put(ATTR_GROUP_NAME, name);

            super.setObjectClass(OBJECT_CLASS);
        }
        else
        {
            super.myAttrs =  JetspeedLDAP.read(ldapurl);
            this.id = getutil(ATTR_GROUP_ID);
            this.name = getutil(ATTR_GROUP_NAME);
        }
    }

    public LDAPGroup(LDAPURL ldapurl)
    {
        super.ldapurl = ldapurl;
        super.myAttrs =  JetspeedLDAP.read(ldapurl);
        this.id = getutil(ATTR_GROUP_ID);
        this.name = getutil(ATTR_GROUP_NAME);
    }

    // --------------------- Persistence operations ----------------------

    public boolean update(boolean create)
    {
        removeutil("createTimeStamp", false);
        removeutil("modifyTimeStamp", false);       

        if (JetspeedLDAP.exists(ldapurl))
        {
            JetspeedLDAP.deleteAttrs(super.ldapurl, super.rmAttrs);
            JetspeedLDAP.updateEntry(super.ldapurl, super.myAttrs);
        }
        else if (create)
        {
            JetspeedLDAP.addEntry(super.ldapurl, super.myAttrs);
        }
        else
        {
            return false;
        }

        return true;
    }

    // ------------------------ Accessor methods -------------------------

    /**
     * Get the name of the Group
     *
     * @return the name of the group.
     */
    public String getName()
    {
        return name;
    }
 
    /**
     * Set the name of the Group
     *
     * @param groupName the name of the Group.
     */
    public void setName(String groupName)
    {
        name = groupName;
    }

    /**
     * Get the id of the Group
     *
     * @return the id of the group.
     */
    public String getId()
    {
        return id;
    }

    /**
     * Set the id of the Group
     *
     * @param id the new id for the group
     */
    public void setId(String id)
    {      
        if (this.id == null)
        {
            this.id = id;
        }
    }

    public boolean isNew()
    {
        return isNew;
    }

    void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

}