/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.om.profile.psml;

import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Title;

/**
 * Bean like implementation of a meta-info repository
 * 
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: PsmlMetaInfo.java,v 1.3 2002/09/27 16:54:22 ggolden Exp $
 */
public class PsmlMetaInfo implements MetaInfo
{     
    private Vector titles = new Vector();

    private String description = null;
         
    private String image = null;

    /** @return the default title for this entry */         
    public String getTitle()
    {
        return getTitle(null);
    }
                    
    /** Sets the default title for this entry
     * @param title the new title for this entry
     */                    
    public void setTitle( String title )
    {
        setTitle(title, null);
    }

    /** @return the title specified locale for this entry */         
    public String getTitle( Locale locale )
    {
        String defTitle = null;
        Iterator it = titles.iterator();
        while (it.hasNext())
        {
            Title title = (Title)it.next();
            if (title.getLocaleObject() == null)
            {
                defTitle = title.getName();
                if (locale == null) return defTitle;
            }
            else
            {
                if (locale.equals(title.getLocaleObject()))
                    return title.getName();
            }
        }
        return defTitle;
    }

    /** Sets the title specified locale for this entry
     * @param title the new title specified locale for this entry
     */                    
    public void setTitle( String title, Locale locale )
    {
        Title tmpTitle;
        Iterator it = titles.iterator();
        while (it.hasNext())
        {
            tmpTitle = (Title)it.next();
            Locale tmpLocale = tmpTitle.getLocaleObject();
            if (tmpLocale == null)
            {
                if (locale == null)
                {
                    tmpTitle.setName(title);
                    return;
                }
            }
            else
            {
                if (tmpLocale.equals(locale))
                {
                    tmpTitle.setName(title);
                    return;
                }
            }
        }

        tmpTitle = new PsmlTitle();
        tmpTitle.setName(title);
        tmpTitle.setLocaleObject(locale);
        titles.add(tmpTitle);
    }

    /** @return value of property titles */         
    public Vector getTitles()
    {
        return this.titles;
    }

    /** Sets the titles for this entry
     * @param titles the new value of property titles.
     */                    
    public void setTitles( Vector titles )
    {
        this.titles = titles;
    }

    /**
     * Test if a title exists for this entry, in the specified locale.
     *
     * @param locale the title locale
     * @return true is the title exists in the specified locale
     */
    public boolean hasTitle(Locale locale)
    {
        Iterator it = titles.iterator();
        while (it.hasNext())
        {
            Title title = (Title)it.next();
            if (title.getLocaleObject() == null)
            {
                if (locale == null) return true;
            }
            else
            {
                if (title.getLocaleObject().equals(locale)) return true;
            }
        }
        return false;
    }

    /** @return the description for this entry */         
    public String getDescription()
    {
        return this.description;
    }
                                
    /** Sets the description for this entry
     * @param description the new description for this entry
     */                    
    public void setDescription( String description )
    {
        this.description = description;
    }
    
    /** @return the image link for this entry */         
    public String getImage()
    {
        return this.image;
    }
                                
    /** Sets the image URL attached to this entry
     * @param image the image URL to link to this entry
     */                    
    public void setImage( String image )
    {
        this.image = image;
    }
    
    /**
     * Create a clone of this object
     */
    public Object clone()
        throws java.lang.CloneNotSupportedException
    {
        Object cloned = super.clone();
        return cloned;

    }   // clone
}
