package org.apache.jetspeed.om.dbpsml;

// JDK classes
import java.util.List;
import java.sql.Connection;

// Turbine classes
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;

//Torque classes
import org.apache.torque.util.Criteria;
import org.apache.torque.util.BasePeer;

// Local classes
import org.apache.jetspeed.om.dbpsml.map.*;

import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.services.psmlmanager.db.DBOperations;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.Profiler;

/**
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Mon Sep 10 13:30:53 PDT 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  *
  * @author <a href="mailto:adambalk@cisco.com">Atul Dambalkar</a>
  * @version $Id: JetspeedRoleProfilePeer.java,v 1.10 2002/11/21 16:01:46 taylor Exp $
  */
public class JetspeedRoleProfilePeer
    extends org.apache.jetspeed.om.dbpsml.BaseJetspeedRoleProfilePeer
    implements DBOperations
{

    /**
     * Default constructor.
     */
    public JetspeedRoleProfilePeer() {}


    /**
     * Insert a role profile record in the database table.
     *
     * @param profile Profile object that will be inserted in the database
     * @param connection A database connection to use
     */
    public void insert(Profile profile, Connection connection) throws Exception
    {
        doInsertOrUpdate(profile, INSERT, connection);
    }

    /**
     * Update role profile record from the database table.
     *
     * @param profile Profile object that will be deleted from the database
     * @param connection A database connection to use
     */
    public void update(Profile profile, Connection connection) throws Exception
    {
        doInsertOrUpdate(profile, UPDATE, connection);
    }


    private void doInsertOrUpdate(Profile profile, int operation, Connection connection)
                           throws Exception
    {
        JetspeedRoleProfile roleProfile = new JetspeedRoleProfile();
        DatabasePsmlManager service = (DatabasePsmlManager)PsmlManager.getService();

        roleProfile.setRoleName(profile.getRole().getName());
        roleProfile.setMediaType(profile.getMediaType());
        roleProfile.setLanguage(profile.getLanguage());
        roleProfile.setCountry(profile.getCountry());
        String name = profile.getName();
        if (name == null || name.equals(""))
        {
            profile.setName(Profiler.FULL_DEFAULT_PROFILE);
        }
        else if (!name.endsWith(Profiler.DEFAULT_EXTENSION))
        {
            profile.setName(name + Profiler.DEFAULT_EXTENSION);
        }
        roleProfile.setPage(profile.getName());
        roleProfile.setProfile(DBUtils.portletsToBytes(
                                       profile.getDocument().getPortlets(), service.getMapping()));

        if (operation == INSERT)
        {
            super.doInsert(roleProfile, connection);
        }
        else if (operation == UPDATE)
        {
            Criteria values = buildCriteria(roleProfile);
            Criteria select = buildCriteria(roleProfile);
            select.remove(PROFILE);
            BasePeer.doUpdate( select, values, connection );
        }
    }

    /**
     * Delete role profile record from the database table.
     *
     * @param profile Profile object that will be deleted from the database
     * @param connection A database connection to use
     */
    public void delete(ProfileLocator locator, Connection connection) throws Exception
    {
        super.doDelete(buildCriteria(locator), connection);
    }

    /**
     * Select role profile record from the database table for the given
     * locator object.
     *
     * @param locator ProfileLocator object that will be used to select required
     * profile from the database
     * @param connection A database connection to use
     * @return List of records that statisfy the given locator criteria.
     */
    public List select(ProfileLocator locator, Connection connection) throws Exception
    {
        return super.doSelect(buildCriteria(locator), connection);
    }

    /**
     * Select role profile record from the database table for the given
     * locator object and return list ordered by primary key.
     *
     * @param locator ProfileLocator object that will be used to select required
     * profile from the database
     * @param connection A database connection to use
     * @return List of records that statisfy the given locator criteria.
     */
    public List selectOrdered(ProfileLocator locator, Connection connection) throws Exception
    {
        Criteria criteria = buildCriteria(locator);

        criteria.addAscendingOrderByColumn(ROLE_NAME);
        criteria.addAscendingOrderByColumn(MEDIA_TYPE);
        criteria.addAscendingOrderByColumn(LANGUAGE);
        criteria.addAscendingOrderByColumn(COUNTRY);
        criteria.addAscendingOrderByColumn(PAGE);

        return super.doSelect(criteria, connection);
    }

    /**
     * Delete all records from the database table for a role.
     *
     * @param role Role object for which all the records will be deleted from the database
     * @param connection A database connection to use
     */
    public void delete(Role role, Connection connection) throws Exception
    {
        Criteria criteria = new Criteria();

        criteria.add(ROLE_NAME, role.getName());

        super.doDelete(criteria, connection);
    }

    /*
     * Build criteria for selecting, deleting groups
     *
     */
    protected Criteria buildCriteria(ProfileLocator locator)
    {
        Criteria criteria = new Criteria();
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String roleName = null;

        Role role = locator.getRole();
        if (role != null) {
            roleName = role.getName();
        }

        if (roleName != null && roleName.length() > 0)
        {
            criteria.add(ROLE_NAME, roleName);
        }

        if (pageName != null && pageName.length() > 0)
        {
            criteria.add(PAGE, pageName);
        }

        if (mediaType != null && mediaType.length() > 0)
        {
            criteria.add(MEDIA_TYPE, locator.getMediaType());
        }

        criteria.add(LANGUAGE, locator.getLanguage());
        criteria.add(COUNTRY, locator.getCountry());

        return criteria;
    }
}

