/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.parameters;

//ecs stuff
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;

// java stuff
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Map;
import java.util.Enumeration;

//turbine support
import org.apache.turbine.util.RunData;

/**
 *  Returns a group of check boxes using the following options:
 *  <UL>
 *  <LI><code>items</code>: list of comma-delimited check box names/values</LI>
 *  <LI><code>layout</code> [$northsouth|<strong>$eastwest</strong>]: presentation layout</LI>
 *  <LI><code>prefix</code>: prefix to use for check box names, default="cb"</LI> 
 * </UL>
 * 
 * @author <a href="mailto:mark_orciuch@ngsltd.com">Mark Orciuch</a>
 * @version $Id: CheckBoxGroup.java,v 1.2 2002/09/20 19:31:44 morciuch Exp $
 */
public class CheckBoxGroup extends ParameterPresentationStyle
{

    public static final String ITEMS = "items";
    public static final String LAYOUT = "layout";
    public static final String LAYOUT_EW = "$eastwest";
    public static final String LAYOUT_NS = "$northsouth";
    public static final String PREFIX = "prefix";
    public static final String PREFIX_DEFAULT = "cb";

    /**
     * Returns presentation control
     */
    public String getContent(RunData data, String name, String value, Map parms)
    {

        ElementContainer result = new ElementContainer();
        String items = (String)parms.get(this.ITEMS);
        String layout = (String)parms.get(this.LAYOUT);
        String prefix = (String)parms.get(this.PREFIX);
        if (prefix == null)
        {
            prefix = PREFIX_DEFAULT;
        }

        StringTokenizer st = new StringTokenizer(items, ",");
        Vector v = new Vector();
        while ( st.hasMoreTokens() )
        {
            String token = st.nextToken().trim();
            if ( !token.equalsIgnoreCase("") )
            {
                v.add(token);
            }
        }

        Table t = new Table();

        for ( Enumeration e = v.elements(); e.hasMoreElements(); )
        {
            String item = ((String)e.nextElement()).trim();
            Input cb = new Input(Input.CHECKBOX, prefix + item, item);
            cb.setChecked(value.indexOf(item) >= 0);
            cb.setOnClick(getJavascript(name, v, prefix));
            ElementContainer temp = new ElementContainer();
            temp.addElement(cb).addElement("&nbsp;").addElement(item);
            if ( layout.equalsIgnoreCase(this.LAYOUT_NS) )
            {
                t.addElement(new TR().addElement(new TD(temp)));
            } else
            {
                result.addElement(temp);
            }
        }

        if ( layout.equalsIgnoreCase(this.LAYOUT_NS) )
        {
            result.addElement(t);
        }

        result.addElement(new Input(Input.HIDDEN, name, value));

        return result.toString();

    }

    /**
     * 
     * @param name
     * @param v
     * @return string
     */
    private String getJavascript(String name, Vector v, String prefix)
    {

        StringBuffer result = new StringBuffer();
        result.append(name).append(".value = ");

        for ( Enumeration e = v.elements(); e.hasMoreElements(); )
        {
            String item = prefix + (String)e.nextElement();
            result.append("((");
            result.append(item);
            result.append(".checked) ? ");
            result.append(item);
            result.append(".value : '')");
            if ( e.hasMoreElements() )
            {
                result.append(" + \',\' + ");
            }
        }

        return result.toString();
    }

    /**
     *  Test method
     */
    public static void main(String args[])
    {

        CheckBoxGroup cbg = new CheckBoxGroup();    
        java.util.Hashtable parms = new java.util.Hashtable();
        parms.put(ITEMS, "Tomaszewski,Gorgon,Zmuda,Szymanowski,Musial,Kasperczak,Deyna,Cmikiewicz,Lato,Szarmach,Gadocha");
        System.out.println(cbg.getContent(null, "test", "Deyna,,,,Gorgon,Lato,Szarmach,", parms));

    }


}
