/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.modules.layouts;

// Jetspeed imports
import org.apache.jetspeed.services.TemplateLocator;

//Turbine imports
import org.apache.turbine.modules.Layout;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.jsp.TurbineJspService;

/*
 * This Layout module allows JSP templates to be used as layouts.
 * Same as turbine's JspLayout, except that:-
 * - The Mimetype is not fixed text/html but the one set in JetspeedTemplatePage
 * - Navigations are handled by the layout Jsp only
 * - Not the result of the screen is placed in the request, just the screen name and relative path.
 *   The Ecs.jsp will handle ecs-screen processing.
 *
 * @author <a href="mailto:ingo@raleigh.ibm.com">Ingo Schuster</a>
 * @author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
 * @version $Id: JetspeedJspLayout.java,v 1.18 2002/07/11 04:22:56 paulsp Exp $
 */
public class JetspeedJspLayout extends Layout
{
    /** 
     * Method called by LayoutLoader.
     *
     * @param RunData
     */
    public void doBuild(RunData data) throws Exception
    {
        String screenPath  = null;
        
        // FIXME:  using TurbineJspService instead of the interface JspService 
        //         because getRelativeTemplateName() is not defined in the 
        //         interface.  A patch has been submitted to Turbine.

        TurbineJspService jsp = (TurbineJspService)TurbineServices.getInstance().getService(JspService.SERVICE_NAME);

        // set the content type (including charset)
        data.getResponse().setContentType(data.getContentType());
        Log.info("JetspeedJspLayout: set response content type to " + data.getContentType());

        // tell turbine that the response is handled by the JSP system.
        data.declareDirectResponse();

        // Put the path to the screen template into the request.
        String path = TemplateLocator.locateScreenTemplate(data, data.getScreenTemplate());
        if (path != null)
            screenPath = jsp.getRelativeTemplateName("/screens" + path);
        data.getRequest().setAttribute("screenJsp", screenPath);
        Log.info("JetspeedJspLayout: set 'screenJSP' to: " + screenPath );

        // Grab the layout template set in the JetspeedTemplatePage.  
        String templateName = data.getLayoutTemplate();

        // Finally, generate the layout template and output to the response
        Log.info("JetspeedJspLayout: forward request to: " +  "/layouts" + templateName);
        jsp.handleRequest(data, "/layouts" + templateName, false);
    }
    
}
