/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.RegistryEntry;

// Turbine stuff
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

// Velocity Stuff
import org.apache.velocity.context.Context;

import java.util.Vector;
import java.util.Iterator;

/**
 * This action enables to browse any of the system registries for displaying
 * available entries and information on these entries
 * 
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 */
public class RegistryBrowseAction extends VelocityPortletAction
{

    /** 
     * Subclasses must override this method to provide default behavior 
     * for the portlet action
     */
    protected void buildNormalContext( VelocityPortlet portlet, 
                                       Context context,
                                       RunData rundata )
    {
        int start = rundata.getParameters().getInt("start",0);
        
        if (start < 0) start = 0;

        String pageSize = portlet.getPortletConfig()
                                 .getInitParameter("page-size","20");

        int size = Integer.parseInt(pageSize);

        int next = start+size+1;
        int prev = start-size-1;
                
        String regName = portlet.getPortletConfig()
                                .getInitParameter("registry",Registry.PORTLET);

        Iterator i = Registry.get(regName).listEntryNames();
        Vector entries = new Vector();
        
        int count = 0;

        while(i.hasNext() && (count < next) )
        {
            String name = (String)i.next();
            
            RegistryEntry regEntry = Registry.getEntry(regName,name);
    
            if ( (regEntry!=null) && (!regEntry.isHidden()) )
            {
                if (count >= start)
                {
                    entries.add(regEntry);
                }
                count++;
            }
        }
                    
        context.put("registry", entries);
        if (start > 0)
        {
            context.put("prev",String.valueOf(prev));
        }
        if (    (count == next) 
             && ( count < Registry.get(regName).getEntryCount() ) )
        {
            context.put("next",String.valueOf(next));
        }
    }
}
