/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions;


// JDK Stuff
import java.sql.*;
import java.util.*;

// External Stuff
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.resources.TurbineResources;

import org.apache.turbine.util.RunData;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;

public class PrepareScreenEditAccount extends Action
{
    public void doPerform( RunData rundata ) throws Exception
    {
        // check to make sure the user has logged in before accessing this screen
        if ( ! rundata.getUser().hasLoggedIn() )
        {
            rundata.setScreenTemplate( TurbineResources.getString( "services.JspService.screen.error.NotLoggedIn","Error") );
            return;
        }
        
        // fill in the blanks in the form
        String username  = rundata.getUser().getUserName();
        String firstname = null;
        String lastname  = null;
        String email     = null;

        // for security, get information about the user from the database
        // instead of what we already have cached.
        try
        {
            JetspeedUser user = JetspeedSecurity.getUser(rundata.getUser().getUserName());
            firstname = (String) user.getFirstName();
            lastname  = (String) user.getLastName();
            email     = (String) user.getEmail();
        
            if ( firstname == null )
                firstname = "";
            if ( lastname == null )
                lastname = "";
            if ( email == null )
                email = "";

            Hashtable screenData = new Hashtable();
            screenData.put( "username",  username );
            screenData.put( "firstname", firstname );
            screenData.put( "lastname",  lastname );
            screenData.put( "email",     email );
            rundata.getRequest().setAttribute( "ScreenDataEditAccount", screenData );
    
            return;
        }
        catch(Exception e)
        {
            rundata.setScreenTemplate( TurbineResources.getString( "services.JspService.screen.error.NotLoggedIn","Error") );
            return;
        }
    }
}
