/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.cms.manager;

// JDK
import java.util.Vector;

//Jetspeed
import org.apache.jetspeed.services.cms.JetspeedCMSException;
import org.apache.jetspeed.om.cms.*;
import org.apache.turbine.util.upload.FileItem;

/**
 * Cms manager
 *
 * @author <a href="mailto:christophe.lombart@skynet.be">Christophe Lombart</a>
 */
public interface CmsManager
{

	/**
	* Initialise the CmsManager.
	* @param nameSpace used assigned to the CmsManager. This namespace can be
	* used to read parameters assigned to this namespace in the JR.prop
	*/
	void init (String namespace)
		   throws JetspeedCMSException;

	/**
	* Export the CMS repository into an xml file
	* @param userNode User reference
	* @param xmlFileName output file
	*/
	public void exportRepository (String userNode, String xmlFileName)
		   throws JetspeedCMSException;

	/**
	* Populate a catalog structure from the repository
	*
	* @param userNode User reference
	* @param Catalog object to populate
	*/
	 public void populateCatalog (String userNode, Catalog catalog)
		   throws JetspeedCMSException;

	/**
	* Populate a catalog structure from the repository
	*
	* @param userNode User reference
	* @param catalog object to populate
	* @param withSubCatalog - retrieve or not sub-catalogs
	* @param withContent - retrieve or not child ContentItems
	*/
	public void populateCatalog (String userNode, Catalog catalog,
								 boolean withSubCatalog, boolean withContent)
		   throws JetspeedCMSException;

	/**
	* Populate a catalog structure from the repository
	*
	* @param userNode User reference
	* @param catalog object to populate
	* @param withSubCatalog - retrieve or not sub-catalogs
	* @param withContent - retrieve or not child ContentItems
	* @param numberOfLevels - number of tree level to populate
	*/
	public void populateCatalog (String userNode, Catalog catalog,
								 boolean withSubCatalog, boolean withContent,
								 int numberOfLevels )
		   throws JetspeedCMSException  ;

	/**
	* Get all children from a specific parent uri
	*
	* @param userNode User reference
	* @param parentUri uri used to get children
	*/
	public Vector getUriList (String userNode, String parentUri)
		   throws JetspeedCMSException;


	/**
	* Get a resource object (Catalog or ContentItem)  from the repository
	* based on a uri.
	* @param userNode User reference
	* @param uri
	* @return resource that match to this uri
	*/
	public Resource getResource (String userNode, String uri )
		   throws JetspeedCMSException ;

	/**
	* Get all catalogs defined between 2 uri (from - to)
	*
	* @param userNode User reference
	* @param fromuri : first element of the interval
	* @param toUri  : last element of the interval
	* @return catalogs found between both uri
	*/


	public Vector getCatalogs(String userNode, String fromUri, String toUri)
		   throws JetspeedCMSException ;

	/**
	* Get Security information assigned to an uri
	* @param userNode User reference
	* @param uri for which the security info is asked
	*/
	public Vector getSecurity (String userNode, String uri )
		   throws JetspeedCMSException ;

	/**
	* Grant permission to an uri
	* @param userNode User reference
	* @param uri on which permission has to be set
	* @param userUri User uri reference
	* @param actionUri Action used in the permission (read, modify, write, ...)
	* @param inheritable true if the permission has to be apply on child uri
	* @param negative true if the permission is negative
	*/
	public void grantPermission (String userNode, String objectUri , String userUri,
								 String actionUri, boolean inheritable,
								 boolean negative)
		   throws JetspeedCMSException ;
	/**
	* Create a new resource in the repository
	* @param userNode User reference
	* @param resource object describing the new resource
	*/
	public void createResource (String userNode, Resource resource)
		   throws JetspeedCMSException ;
	/**
	* Create a new resource in the repository with a content stream
	* @param userNode User reference
	* @param resource object describing the new resource
	* @param stream stream which match to the resource content
	*/
	public void createResource (String userNode, Resource resource, FileItem stream)
		   throws JetspeedCMSException;

	/**
	* Create a new link in the repository
	* @param userNode User reference
	* @param link object describing the new link
	*/
	public void createLink (String userNode, Link link)
	 throws JetspeedCMSException;
}
