/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.om.cms.slide;

import java.util.Vector;
import java.util.TreeMap;
import java.util.Comparator;

import org.apache.jetspeed.om.cms.*;

/**
 * <p> Wrapper class for a slide catalog resource (ObjectNode).<br>
 * Used to access to the catalog attributes
 *
 * @author <a href="mailto:christophe.lombart@skynet.be">Christophe Lombart</a>
 *
 */
public class SlideCatalog extends SlideResource implements Catalog 
{

	protected String logicalName = "";
	private String title = "";
	private String parentUri ="";
	public static String TYPE="Catalog";
	private TreeMap items = new TreeMap(new ItemComparator());

	/**
	* Constructor
	*/
	public SlideCatalog()
	{
		super();
		descriptor.setProperty("resourcetype","<collection/>");
	}

	public void addResource(String itemKey, Resource resource)
	{
		items.put(itemKey, resource);
	}

	public Vector getItems()
	{
		return new Vector(items.values()); // return a vector of "Resource"
	}

	/**
	* Use in the comparator class for the treemap
	*
	*/
	public String getKey()
	{
		return "1" + this.getTitle( ); // "1" because the catalog should
                                    // before the contentItem reference
	}

	public void setLogicalName(String logicalName)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("logicalName", logicalName);
		}

     	this.logicalName = logicalName;
	}

	public String getLogicalName()
	{
		if ((descriptor != null) && ((this.logicalName == null) || (this.logicalName.equals(""))))
		{
			this.logicalName = (String) this.getProperty("logicalName");
		}

		return this.logicalName;
	}

	public void setTitle(String title)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("title", title);
		}

		this.title = title;
	}

	public String getTitle()
	{
		if ((descriptor != null) && ((this.title == null) || (this.title.equals(""))))
		{
			this.title = (String) this.getProperty("title");
		}

		return this.title;
	}


	public void setParentUri(String parentUri)
	{
		if (descriptor != null)
		{
			descriptor.setProperty("parentUri", parentUri);
		}

		this.parentUri = parentUri;
	}

	public String getParentUri()
	{
		if ((descriptor != null) && ((this.parentUri == null) || (this.parentUri.equals(""))))
		{
			this.parentUri = (String) this.getProperty("parentUri");
		}

		return this.parentUri;
	}

	public String getType()
	{
		return SlideCatalog.TYPE;
	}

	class ItemComparator implements Comparator
	{
		public int compare (Object key1, Object key2)
		{
        	return ((String) key1).compareTo((String)key2);
		}
	}
}
