#!/bin/sh

#--------------------------------------------
# You may modify the default values below.
#--------------------------------------------

# The name of the build file to use
BUILDFILE=build.xml

# Root directory for the project
PROJECTDIR=..

# Directory where necessary runtime Java libraries are found
LIBDIR=${PROJECTDIR}/lib

# Directory where necessary build Java libraries are found
BUILDDIR=${PROJECTDIR}/build/lib

# External dependencies jar required for building this project
JAR_DEPENDENCIES=`ls ${PROJECTDIR:-.}/../jakarta-site2/lib/jdom*.jar 2>/dev/null`

#--------------------------------------------
# No need to edit anything past here
#--------------------------------------------

# Try to find Java Home directory, from JAVA_HOME environment 
# or java executable found in PATH

if test -z "${JAVA_HOME}" ; then
    # JAVA_HOME is not set, try to set it if java is in PATH
    JAVABIN=`type -p java`
    if [ $? -eq 0 ]
    then
        # We found something, clean the path to get a valid JAVA_HOME
        JAVA_HOME=`echo $JAVABIN | sed -e 's/\/bin\/java.*//' `
    else
        echo "ERROR: JAVA_HOME not found in your environment."
        echo "Please, set the JAVA_HOME variable in your environment to match the"
        echo "location of the Java Virtual Machine you want to use."
        exit
    fi
fi

# convert the existing path to unix
if [ "$OSTYPE" = "cygwin32" ] || [ "$OSTYPE" = "cygwin" ] ; then
   CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
   JAVA_HOME=`cygpath --path --unix "$JAVA_HOME"`
fi

# Defin the java executable path
if [ "$JAVABIN" = "" ] ; then
  JAVABIN=${JAVA_HOME}/bin/java
fi


# Find all jars defined in builddir and add them to the classpath
for lib in ${BUILDDIR:-.}/*.jar
do
    CLASSPATH=${CLASSPATH}:${lib}
done

# Add other dependencies required for building
for lib in ${LIBDIR:-.}/*.jar
do
    CLASSPATH=${CLASSPATH}:${lib}
done

# Add known external dependencies
for lib in ${JAR_DEPENDENCIES}
do
    CLASSPATH=${CLASSPATH}:${lib}
done

# Try to include tools.jar for compilation
if test -f ${JAVA_HOME}/lib/tools.jar ; then
    CLASSPATH=${CLASSPATH}:${JAVA_HOME}/lib/tools.jar
fi

# convert the unix path to windows
if [ "$OSTYPE" = "cygwin32" ] || [ "$OSTYPE" = "cygwin" ] ; then
   CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
   JAVA_HOME=`cygpath --path --windows "$JAVA_HOME"`
fi

# Call Ant
${JAVABIN} -classpath "${CLASSPATH}" org.apache.tools.ant.Main \
           -buildfile "${BUILDFILE}" "$@"
