/*
 * Decompiled with CFR 0.152.
 */
package slidestore.reference;

import java.util.Hashtable;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import slidestore.reference.FileContentStore;
import slidestore.reference.MemoryDescriptorsStore;

public class DefaultStore
extends MemoryDescriptorsStore
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    private FileContentStore contentStore = new FileContentStore();

    public synchronized void commit() throws ServiceAccessException {
        super.commit();
        this.contentStore.commit();
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        super.connect();
        this.contentStore.connect();
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        this.contentStore.createRevisionContent(uri, revisionDescriptor, revisionContent);
    }

    public synchronized void disconnect() throws ServiceDisconnectionFailedException {
        super.disconnect();
        this.contentStore.disconnect();
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        this.contentStore.initialize(token);
    }

    public boolean isConnected() throws ServiceAccessException {
        return super.isConnected() && this.contentStore.isConnected();
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.contentStore.removeRevisionContent(uri, revisionDescriptor);
    }

    public void reset() throws ServiceResetFailedException {
        super.reset();
        this.contentStore.reset();
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        return this.contentStore.retrieveRevisionContent(uri, revisionDescriptor);
    }

    public synchronized void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        super.setParameters(parameters);
        this.contentStore.setParameters(parameters);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        this.contentStore.storeRevisionContent(uri, revisionDescriptor, revisionContent);
    }
}

