/*
 * Decompiled with CFR 0.152.
 */
package slidestore.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import slidestore.j2ee.J2EEStore;
import slidestore.reference.util.JDBCAwareInputStream;

public class J2EEContentStore
extends J2EEStore
implements ContentStore {
    public static final int BUFFER_SIZE = 2048;
    public static final String CHARACTER_ENCODING = "8859_1";
    protected static final int REVISION_URI = 1;
    protected static final int REVISION_NUMBER = 2;
    protected static final int REVISION_CONTENT = 3;

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        Connection connection = this.getCurrentConnection();
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        long contentLength = revisionDescriptor.getContentLength();
        PreparedStatement selectStatement = null;
        try {
            try {
                selectStatement = connection.prepareStatement("select 1 from revisioncontent where uri = ? and xnumber = ?");
                selectStatement.setString(1, revisionUri);
                selectStatement.setString(2, revisionNumber);
                ResultSet rs = selectStatement.executeQuery();
                if (rs.next()) {
                    rs.close();
                    throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionAlreadyExistException e) {
                this.getLogger().log((Object)("RevisionAlreadyExistException encountered for " + revisionUri + " revision " + revisionNumber), ((AbstractServiceBase)this).LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var11_14 = null;
            this.closeStatement(selectStatement);
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.closeStatement(selectStatement);
            throw throwable;
        }
    }

    protected void removeContent(String revisionUri, String revisionNumber) throws SQLException {
        Connection connection = this.getCurrentConnection();
        PreparedStatement deleteStatement = connection.prepareStatement("delete from revisioncontent where uri = ? and xnumber = ?");
        deleteStatement.setString(1, revisionUri);
        deleteStatement.setString(2, revisionNumber);
        deleteStatement.executeUpdate();
        deleteStatement.close();
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        try {
            this.removeContent(revisionUri, revisionNumber);
        }
        catch (Exception e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        Connection connection = this.getCurrentConnection();
        NodeRevisionContent result = null;
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        PreparedStatement selectStatement = null;
        try {
            selectStatement = connection.prepareStatement("select * from revisioncontent where uri = ? and xnumber = ?");
            selectStatement.setString(1, revisionUri);
            selectStatement.setString(2, revisionNumber);
            ResultSet rs = selectStatement.executeQuery();
            if (!rs.next()) {
                rs.close();
                selectStatement.close();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            InputStream is = rs.getBinaryStream(3);
            if (is == null) {
                rs.close();
                selectStatement.close();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            result = new NodeRevisionContent();
            result.setContent(is);
            result.setContent((InputStream)new JDBCAwareInputStream(is, selectStatement));
        }
        catch (SQLException e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (RevisionNotFoundException e) {
            this.getLogger().log((Object)("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber), ((AbstractServiceBase)this).LOG_CHANNEL, 4);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        return result;
    }

    protected void storeContent(String revisionUri, String revisionNumber, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        Connection connection = this.getCurrentConnection();
        PreparedStatement insertStatement = connection.prepareStatement("insert into revisioncontent values(?, ?, ?)");
        insertStatement.setString(1, revisionUri);
        insertStatement.setString(2, revisionNumber);
        InputStream is = revisionContent.streamContent();
        if (is != null) {
            Object os = null;
            byte[] buffer = new byte[2048];
            long position = 0L;
            long contentLength = revisionDescriptor.getContentLength();
            File tempFile = null;
            String tempFileName = null;
            if (contentLength == -1L) {
                try {
                    int nChar;
                    tempFileName = String.valueOf(revisionUri) + "-" + revisionNumber;
                    tempFileName = tempFileName.replace('/', '.');
                    int tempFileNameLength = tempFileName.length();
                    if (tempFileNameLength > 200) {
                        tempFileName = tempFileName.substring(tempFileNameLength - 200, tempFileNameLength);
                    }
                    tempFile = File.createTempFile(tempFileName, null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    while ((nChar = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, nChar);
                        position += (long)nChar;
                    }
                    fos.close();
                    is = new FileInputStream(tempFile);
                    contentLength = tempFile.length();
                }
                catch (IOException ex) {
                    this.getLogger().log((Object)(String.valueOf(ex.toString()) + " during the calculation of the content length."), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.getLogger().log((Object)("tempFileName: " + tempFileName), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.getLogger().log((Object)("tempFile: " + tempFile.getAbsolutePath()), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    throw ex;
                }
            }
            insertStatement.setBinaryStream(3, is, (int)contentLength);
            insertStatement.executeUpdate();
            revisionDescriptor.setContentLength(contentLength);
            if (tempFile != null) {
                is.close();
                tempFile.delete();
            }
        }
        insertStatement.close();
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        Connection connection = this.getCurrentConnection();
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        PreparedStatement selectStatement = null;
        try {
            try {
                selectStatement = connection.prepareStatement("select 1 from revisioncontent where uri = ? and xnumber = ?");
                selectStatement.setString(1, revisionUri);
                selectStatement.setString(2, revisionNumber);
                ResultSet rs = selectStatement.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    selectStatement.close();
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.removeContent(revisionUri, revisionNumber);
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionNotFoundException e) {
                this.getLogger().log((Object)("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber), ((AbstractServiceBase)this).LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var9_13 = null;
            this.closeStatement(selectStatement);
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.closeStatement(selectStatement);
            throw throwable;
        }
    }
}

