/*
 * Decompiled with CFR 0.152.
 */
package slidestore.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;

public class FileDescriptorsStoreNoVersioning
extends AbstractSimpleService
implements RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
NodeStore {
    protected static final int SUBJECT = 0;
    protected static final int ACTION = 1;
    protected static final int LINK = 2;
    private String rootpath;

    public synchronized void commit() throws ServiceAccessException {
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
    }

    public synchronized void disconnect() throws ServiceDisconnectionFailedException {
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> result = new Vector<NodePermission>();
        try {
            File file = new File(String.valueOf(this.rootpath) + uri + ".acl");
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileReader reader = new FileReader(file);
            BufferedReader bfReader = new BufferedReader(reader);
            NodePermission permission = null;
            String subject = null;
            String action = null;
            String inheritable = null;
            String negative = null;
            while (!((subject = bfReader.readLine()) == null || subject.equals("") || (action = bfReader.readLine()) == null || action.equals("") || (inheritable = bfReader.readLine()) == null || inheritable.equals("") || (negative = bfReader.readLine()) == null || negative.equals(""))) {
                permission = new NodePermission(uri.toString(), subject, action, Boolean.getBoolean(inheritable), Boolean.getBoolean(negative));
                result.addElement(permission);
            }
            bfReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        return result.elements();
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            File file = new File(String.valueOf(this.rootpath) + uri + ".acl");
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(file);
            PrintWriter printer = new PrintWriter(writer);
            Enumeration oldPermissions = this.enumeratePermissions(uri);
            while (oldPermissions.hasMoreElements()) {
                NodePermission currentPermission = (NodePermission)oldPermissions.nextElement();
                printer.println(currentPermission.getSubjectUri());
                printer.println(currentPermission.getActionUri());
                printer.println(currentPermission.isInheritable());
                printer.println(currentPermission.isNegative());
            }
            printer.println(permission.getSubjectUri());
            printer.println(permission.getActionUri());
            printer.println(permission.isInheritable());
            printer.println(permission.isNegative());
            printer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            File baseDir = new File(this.rootpath);
            baseDir.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceInitializationFailedException((Service)this, e);
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
    }

    public void reset() throws ServiceResetFailedException {
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        File file;
        int objectType = 0;
        String linkTo = null;
        SubjectNode result = null;
        Vector<String> childrenVector = new Vector<String>();
        Vector linksVector = new Vector();
        String relative = uri.getRelative();
        if (relative.equals("")) {
            relative = "/";
        }
        try {
            FileReader reader;
            BufferedReader bfReader;
            String type;
            file = new File(String.valueOf(this.rootpath) + relative + ".structure");
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if ((type = (bfReader = new BufferedReader(reader = new FileReader(file))).readLine()) != null) {
                objectType = Integer.parseInt(type);
            }
            if (objectType == 2) {
                linkTo = bfReader.readLine();
            }
            bfReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (relative.equals("/")) {
                throw new ObjectNotFoundException(uri);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        try {
            file = new File(String.valueOf(this.rootpath) + uri.getRelative());
            if (file.isDirectory()) {
                String[] children = file.list();
                int i = 0;
                while (i < children.length) {
                    String current = children[i].replace('\\', '/');
                    int pos = current.indexOf(uri.toString());
                    System.out.println("Adding child :" + current.substring(pos + uri.toString().length()));
                    childrenVector.addElement(current.substring(pos + uri.toString().length()));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        switch (objectType) {
            case 0: {
                result = new SubjectNode(uri.toString(), childrenVector, linksVector);
                break;
            }
            case 1: {
                result = new ActionNode(uri.toString(), childrenVector, linksVector);
                break;
            }
            case 2: {
                result = new LinkNode(uri.toString(), childrenVector, linksVector, linkTo);
                break;
            }
        }
        return result;
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        return null;
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionNumber initialRevision = new NodeRevisionNumber();
        Hashtable workingRevisions = new Hashtable();
        Hashtable latestRevisionNumbers = new Hashtable();
        Hashtable branches = new Hashtable();
        boolean isVersioned = false;
        return new NodeRevisionDescriptors(uri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            File file = new File(String.valueOf(this.rootpath) + uri + ".acl");
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(file);
            PrintWriter printer = new PrintWriter(writer);
            Enumeration oldPermissions = this.enumeratePermissions(uri);
            while (oldPermissions.hasMoreElements()) {
                NodePermission currentPermission = (NodePermission)oldPermissions.nextElement();
                if (currentPermission.equals((Object)permission)) continue;
                printer.println(currentPermission.getSubjectUri());
                printer.println(currentPermission.getActionUri());
                printer.println(currentPermission.isInheritable());
                printer.println(currentPermission.isNegative());
            }
            printer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        try {
            File file = new File(String.valueOf(this.rootpath) + uri + ".acl");
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(file);
            PrintWriter printer = new PrintWriter(writer);
            printer.println();
            printer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public synchronized void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.rootpath = (String)parameters.get("rootpath");
        if (this.rootpath == null) {
            this.rootpath = "";
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
    }
}

