/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.velocity.anakia.Escape;
import org.apache.velocity.context.Context;

public class TorqueDataDumpTask
extends TorqueDataModelTask {
    private String databaseName;
    private String databaseUrl;
    private String databaseDriver;
    private String databaseUser;
    private String databasePassword;
    private Connection conn;
    private Statement stmt;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String v) {
        this.databaseName = v;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String v) {
        this.databaseUrl = v;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String v) {
        this.databaseDriver = v;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String v) {
        this.databaseUser = v;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String v) {
        this.databasePassword = v;
    }

    public Context initControlContext() throws Exception {
        super.initControlContext();
        this.context.put("dataset", (Object)"all");
        StringBuffer buf = new StringBuffer("Database settings:\n").append(" driver: ").append(this.databaseDriver).append('\n').append(" URL: ").append(this.databaseUrl).append('\n').append(" user: ").append(this.databaseUser).append('\n').append(" password: ").append(this.databasePassword).append('\n');
        this.log(buf.toString(), 4);
        try {
            Class.forName(this.databaseDriver);
            this.log("DB driver instantiated sucessfuly", 4);
            this.conn = DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword);
            this.log("DB connection established", 4);
            this.context.put("tableTool", (Object)new TableTool());
        }
        catch (SQLException se) {
            System.err.println("SQLException while connecting to DB:");
            se.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("cannot load driver:");
            cnfe.printStackTrace();
        }
        this.context.put("escape", (Object)new Escape());
        return this.context;
    }

    protected void cleanup() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public class TableTool
    implements Iterator {
        private QueryDataSet qds;
        private boolean isEmpty;
        private int curIndex = -1;
        private Record curRec = null;

        public TableTool() {
        }

        protected TableTool(QueryDataSet qds) throws Exception {
            this.qds = qds;
            this.qds.fetchRecords();
            this.isEmpty = qds.size() <= 0;
        }

        public TableTool fetch(String tableName) throws Exception {
            TorqueDataDumpTask.this.log("Fetching data for table " + tableName, 2);
            return new TableTool(new QueryDataSet(TorqueDataDumpTask.this.conn, "SELECT * FROM " + tableName));
        }

        public boolean hasNext() {
            try {
                return this.curIndex < this.qds.size() - 1 && !this.isEmpty;
            }
            catch (Exception se) {
                System.err.println("Exception :");
                se.printStackTrace();
                return false;
            }
        }

        public Object next() throws NoSuchElementException {
            try {
                System.err.print(".");
                this.curRec = this.qds.getRecord(++this.curIndex);
            }
            catch (Exception se) {
                System.err.println("Exception while iterating:");
                se.printStackTrace();
                throw new NoSuchElementException(se.getMessage());
            }
            return this;
        }

        public String get(String columnName) {
            try {
                return this.curRec.getValue(columnName).asString();
            }
            catch (Exception se) {
                TorqueDataDumpTask.this.log("Exception fetching value " + columnName + ": " + se.getMessage(), 0);
                return null;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

