/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastArrayList;
import org.apache.jcs.JCS;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.log4j.Category;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.CacheListener;
import org.apache.torque.manager.MethodResultCache;
import org.apache.torque.manager.NoOpMethodResultCache;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;

public abstract class AbstractBaseManager
implements Serializable {
    protected static final Category category = Category.getInstance((String)(class$org$apache$torque$manager$AbstractBaseManager == null ? (class$org$apache$torque$manager$AbstractBaseManager = AbstractBaseManager.class$("org.apache.torque.manager.AbstractBaseManager")) : class$org$apache$torque$manager$AbstractBaseManager).getName());
    protected transient GroupCacheAccess cache;
    protected MethodResultCache mrCache;
    private Class omClass;
    private String className;
    private String region;
    private boolean lockCache;
    private int inGet;
    private boolean isNew = true;
    protected Map validFields;
    protected Map listenersMap = new HashMap();
    static /* synthetic */ Class class$org$apache$torque$manager$AbstractBaseManager;

    protected Class getOMClass() {
        return this.omClass;
    }

    protected void setOMClass(Class omClass) {
        this.omClass = omClass;
    }

    protected Persistent getOMInstance() throws InstantiationException, IllegalAccessException {
        return (Persistent)this.omClass.newInstance();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) throws TorqueException {
        this.className = v;
        try {
            this.setOMClass(Class.forName(this.getClassName()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new TorqueException("Could not load " + this.getClassName());
        }
    }

    protected Persistent getOMInstance(ObjectKey id) throws TorqueException {
        return this.getOMInstance(id, true);
    }

    protected Persistent getOMInstance(ObjectKey key, boolean fromCache) throws TorqueException {
        Persistent om = null;
        if (fromCache) {
            om = this.cacheGet(key);
        }
        if (om == null) {
            om = this.retrieveStoredOM(key);
            if (fromCache) {
                this.putInstanceImpl(om);
            }
        }
        return om;
    }

    protected Persistent cacheGet(Serializable key) {
        Persistent om = null;
        if (this.cache != null) {
            if (this.lockCache) {
                AbstractBaseManager abstractBaseManager = this;
                synchronized (abstractBaseManager) {
                    om = (Persistent)this.cache.get((Object)key);
                }
            } else {
                ++this.inGet;
                om = (Persistent)this.cache.get((Object)key);
                --this.inGet;
            }
        }
        return om;
    }

    protected void clearImpl() throws TorqueException {
        if (this.cache != null) {
            try {
                this.cache.remove();
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not clear cache due to internal JCS error.", ce);
            }
        }
    }

    protected Persistent removeInstanceImpl(Serializable key) throws TorqueException {
        Persistent oldOm = null;
        if (this.cache != null) {
            AbstractBaseManager abstractBaseManager = this;
            synchronized (abstractBaseManager) {
                this.lockCache = true;
                try {
                    try {
                        oldOm = (Persistent)this.cache.get((Object)key);
                        while (this.inGet > 0) {
                            Thread.yield();
                        }
                        this.cache.remove((Object)key);
                    }
                    catch (CacheException ce) {
                        this.lockCache = false;
                        throw new TorqueException("Could not remove from cache due to internal JCS error.", ce);
                    }
                    Object var6_4 = null;
                    this.lockCache = false;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.lockCache = false;
                    throw throwable;
                }
            }
        }
        return oldOm;
    }

    protected Persistent putInstanceImpl(Persistent om) throws TorqueException {
        ObjectKey key = om.getPrimaryKey();
        return this.putInstanceImpl(key, om);
    }

    protected Persistent putInstanceImpl(Serializable key, Persistent om) throws TorqueException {
        if (this.getOMClass() != null && !this.getOMClass().isInstance(om)) {
            throw new TorqueException(om + "; class=" + om.getClass().getName() + "; id=" + om.getPrimaryKey() + " cannot be cached with " + this.getOMClass().getName() + " objects");
        }
        Persistent oldOm = null;
        if (this.cache != null) {
            AbstractBaseManager abstractBaseManager = this;
            synchronized (abstractBaseManager) {
                this.lockCache = true;
                try {
                    try {
                        oldOm = (Persistent)this.cache.get((Object)key);
                        while (this.inGet > 0) {
                            Thread.yield();
                        }
                        this.cache.put((Object)key, (Object)om);
                    }
                    catch (CacheException ce) {
                        this.lockCache = false;
                        throw new TorqueException("Could not cache due to internal JCS error.", ce);
                    }
                    Object var7_5 = null;
                    this.lockCache = false;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.lockCache = false;
                    throw throwable;
                }
            }
        }
        return oldOm;
    }

    protected abstract Persistent retrieveStoredOM(ObjectKey var1) throws TorqueException;

    protected List getOMs(ObjectKey[] ids) throws TorqueException {
        return this.getOMs(Arrays.asList(ids));
    }

    protected List getOMs(List ids) throws TorqueException {
        return this.getOMs(ids, true);
    }

    protected List getOMs(List ids, boolean fromCache) throws TorqueException {
        ArrayList<Persistent> oms = null;
        if (ids != null && ids.size() > 0) {
            oms = new ArrayList<Persistent>(ids);
            ArrayList<ObjectKey> newIds = new ArrayList<ObjectKey>(ids.size());
            int i = 0;
            while (i < ids.size()) {
                ObjectKey key = (ObjectKey)ids.get(i);
                Persistent om = null;
                if (fromCache) {
                    om = this.cacheGet(key);
                }
                if (om == null) {
                    newIds.add(key);
                } else {
                    oms.set(i, om);
                }
                ++i;
            }
            if (newIds.size() > 0) {
                List newOms = this.retrieveStoredOMs(newIds);
                int i2 = 0;
                while (i2 < oms.size()) {
                    if (oms.get(i2) instanceof ObjectKey) {
                        int j = newOms.size() - 1;
                        while (j >= 0) {
                            Persistent om = (Persistent)newOms.get(j);
                            if (om.getPrimaryKey().equals(oms.get(i2))) {
                                oms.set(i2, om);
                                newOms.remove(j);
                                if (!fromCache) break;
                                this.putInstanceImpl(om);
                                break;
                            }
                            --j;
                        }
                    }
                    ++i2;
                }
            }
        }
        return oms;
    }

    protected abstract List retrieveStoredOMs(List var1) throws TorqueException;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String v) throws TorqueException {
        this.region = v;
        try {
            if (Torque.getConfiguration().getBoolean("manager.useCache")) {
                this.cache = JCS.getInstance((String)this.getRegion());
                this.mrCache = new MethodResultCache(this.cache);
            } else {
                this.mrCache = new NoOpMethodResultCache(this.cache);
            }
        }
        catch (Exception e) {
            throw new TorqueException("Cache could not be initialized", e);
        }
        if (this.cache == null) {
            category.info((Object)("Cache could not be initialized for region: " + v));
        }
    }

    public MethodResultCache getMethodResultCache() {
        if (this.isNew) {
            AbstractBaseManager abstractBaseManager = this;
            synchronized (abstractBaseManager) {
                if (this.isNew) {
                    this.registerAsListener();
                    this.isNew = false;
                }
            }
        }
        return this.mrCache;
    }

    protected void registerAsListener() {
    }

    public void addCacheListenerImpl(CacheListener listener) {
        List keys = listener.getInterestedFields();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (this.validFields == null || !this.validFields.containsKey(key)) continue;
            List listeners = (List)this.listenersMap.get(key);
            if (listeners == null) {
                listeners = this.createSubsetList(key);
            }
            boolean isNew = true;
            Iterator j = listeners.iterator();
            while (j.hasNext()) {
                Object listener2 = ((WeakReference)j.next()).get();
                if (listener2 == null || listener2 != listener) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            listeners.add(new WeakReference<CacheListener>(listener));
        }
    }

    private synchronized List createSubsetList(String key) {
        FastArrayList list = null;
        if (this.listenersMap.containsKey(key)) {
            list = (FastArrayList)this.listenersMap.get(key);
        } else {
            list = new FastArrayList();
            list.setFast(true);
            this.listenersMap.put(key, list);
        }
        return list;
    }

    protected void notifyListeners(List listeners, Persistent oldOm, Persistent om) {
        if (listeners != null) {
            List list = listeners;
            synchronized (list) {
                Iterator i = listeners.iterator();
                while (i.hasNext()) {
                    CacheListener listener = (CacheListener)((WeakReference)i.next()).get();
                    if (listener == null) {
                        i.remove();
                        continue;
                    }
                    if (oldOm == null) {
                        listener.addedObject(om);
                        continue;
                    }
                    listener.refreshedObject(om);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            if (this.region != null) {
                this.setRegion(this.region);
            }
        }
        catch (Exception e) {
            category.error((Object)("Cache could not be initialized for region: " + this.region + "after deserialization"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

