/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    protected Statement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingStatement(DelegatingConnection c, Statement s) {
        super(c);
        this._stmt = s;
        this._conn = c;
    }

    protected void activate() {
        this._closed = false;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).activate();
        }
    }

    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this._stmt.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this._stmt.cancel();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        this._stmt.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._stmt.clearWarnings();
    }

    public void close() throws SQLException {
        this.passivate();
        this._stmt.close();
    }

    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return this._stmt.executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        return new DelegatingResultSet(this, this._stmt.executeQuery(sql));
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql);
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchSize();
    }

    public Statement getInnermostDelegate() {
        Statement s = this._stmt;
        while (s != null && s instanceof DelegatingStatement) {
            if (this != (s = ((DelegatingStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._stmt.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return new DelegatingResultSet(this, this._stmt.getResultSet());
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._stmt.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._stmt.getWarnings();
    }

    protected void passivate() throws SQLException {
        List resultSets;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
            this._conn = null;
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = new ResultSet[resultSets.size()];
            resultSets.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).passivate();
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this._stmt.setCursorName(name);
    }

    public void setDelegate(Statement s) {
        this._stmt = s;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this._stmt.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this._stmt.setQueryTimeout(seconds);
    }
}

