/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingCallableStatement
extends AbandonedTrace
implements CallableStatement {
    protected CallableStatement _stmt = null;
    protected DelegatingConnection _conn = null;

    public DelegatingCallableStatement(DelegatingConnection c, CallableStatement s) {
        super(c);
        this._conn = c;
        this._stmt = s;
    }

    public void addBatch() throws SQLException {
        this._stmt.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this._stmt.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this._stmt.cancel();
    }

    public void clearBatch() throws SQLException {
        this._stmt.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this._stmt.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this._stmt.clearWarnings();
    }

    public void close() throws SQLException {
        List resultSets;
        if (this._conn != null) {
            this._conn.removeTrace(this);
            this._conn = null;
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = new ResultSet[resultSets.size()];
            resultSets.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        this._stmt.close();
    }

    public boolean execute() throws SQLException {
        return this._stmt.execute();
    }

    public boolean execute(String sql) throws SQLException {
        return this._stmt.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        return this._stmt.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        return new DelegatingResultSet(this, this._stmt.executeQuery());
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return new DelegatingResultSet(this, this._stmt.executeQuery(sql));
    }

    public int executeUpdate() throws SQLException {
        return this._stmt.executeUpdate();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this._stmt.executeUpdate(sql);
    }

    public Array getArray(int i) throws SQLException {
        return this._stmt.getArray(i);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this._stmt.getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this._stmt.getBigDecimal(parameterIndex, scale);
    }

    public Blob getBlob(int i) throws SQLException {
        return this._stmt.getBlob(i);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this._stmt.getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this._stmt.getByte(parameterIndex);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this._stmt.getBytes(parameterIndex);
    }

    public Clob getClob(int i) throws SQLException {
        return this._stmt.getClob(i);
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this._stmt.getDate(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getDate(parameterIndex, cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this._stmt.getDouble(parameterIndex);
    }

    public int getFetchDirection() throws SQLException {
        return this._stmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this._stmt.getFetchSize();
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this._stmt.getFloat(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this._stmt.getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this._stmt.getLong(parameterIndex);
    }

    public int getMaxFieldSize() throws SQLException {
        return this._stmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this._stmt.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._stmt.getMetaData();
    }

    public boolean getMoreResults() throws SQLException {
        return this._stmt.getMoreResults();
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this._stmt.getObject(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this._stmt.getObject(i, map);
    }

    public int getQueryTimeout() throws SQLException {
        return this._stmt.getQueryTimeout();
    }

    public Ref getRef(int i) throws SQLException {
        return this._stmt.getRef(i);
    }

    public ResultSet getResultSet() throws SQLException {
        return new DelegatingResultSet(this, this._stmt.getResultSet());
    }

    public int getResultSetConcurrency() throws SQLException {
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this._stmt.getResultSetType();
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this._stmt.getShort(parameterIndex);
    }

    public String getString(int parameterIndex) throws SQLException {
        return this._stmt.getString(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this._stmt.getTime(parameterIndex);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this._stmt.getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getTimestamp(parameterIndex, cal);
    }

    public int getUpdateCount() throws SQLException {
        return this._stmt.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._stmt.getWarnings();
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this._stmt.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this._stmt.registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this._stmt.registerOutParameter(paramIndex, sqlType, typeName);
    }

    public void setArray(int i, Array x) throws SQLException {
        this._stmt.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this._stmt.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this._stmt.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this._stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this._stmt.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this._stmt.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this._stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this._stmt.setClob(i, x);
    }

    public void setCursorName(String name) throws SQLException {
        this._stmt.setCursorName(name);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this._stmt.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this._stmt.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this._stmt.setDouble(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._stmt.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this._stmt.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this._stmt.setFetchSize(rows);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this._stmt.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this._stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this._stmt.setLong(parameterIndex, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this._stmt.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this._stmt.setMaxRows(max);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this._stmt.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this._stmt.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this._stmt.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this._stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this._stmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this._stmt.setQueryTimeout(seconds);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this._stmt.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this._stmt.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this._stmt.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this._stmt.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this._stmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this._stmt.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this._stmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setUnicodeStream(parameterIndex, x, length);
    }

    public boolean wasNull() throws SQLException {
        return this._stmt.wasNull();
    }
}

