/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import java.net.URL;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.mail.HtmlEmail;
import org.apache.velocity.context.Context;

public class VelocityHtmlEmail
extends HtmlEmail {
    private String htmlTemplate = null;
    private String textTemplate = null;
    private RunData data = null;
    private Hashtable embmap = null;

    public VelocityHtmlEmail(RunData data) throws MessagingException {
        this.data = data;
        this.embmap = new Hashtable();
    }

    public VelocityHtmlEmail setHtmlTemplate(String template) {
        this.htmlTemplate = template;
        return this;
    }

    public VelocityHtmlEmail setTextTemplate(String template) {
        this.textTemplate = template;
        return this;
    }

    public void send() throws MessagingException {
        Context context = VelocityHtmlEmail.getContext(this.data);
        context.put("mail", (Object)this);
        String htmlbody = "";
        String textbody = "";
        try {
            if (this.htmlTemplate != null) {
                htmlbody = TurbineVelocity.handleRequest(context, this.htmlTemplate);
            }
            if (this.textTemplate != null) {
                textbody = TurbineVelocity.handleRequest(context, this.textTemplate);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Cannot parse template", e);
        }
        this.setHtmlMsg(htmlbody);
        this.setTextMsg(textbody);
        super.send();
    }

    public String embed(String surl, String name) throws MessagingException {
        String cid = "";
        try {
            URL url = new URL(surl);
            cid = super.embed(url, name);
            this.embmap.put(name, cid);
        }
        catch (Exception e) {
            Log.error("cannot embed " + surl + ": ", e);
        }
        return cid;
    }

    public String getCid(String filename) {
        String cid = (String)this.embmap.get(filename);
        return "cid:" + cid;
    }

    private static final Context getContext(RunData data) {
        Context vc = (Context)data.getTemplateInfo().getTemplateContext("VELOCITY_CONTEXT");
        if (vc == null) {
            vc = TurbineVelocity.getContext(data);
            data.getTemplateInfo().setTemplateContext("VELOCITY_CONTEXT", vc);
        }
        return vc;
    }
}

