/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.turbine.util.TurbineRuntimeException;

public class TurbineException
extends Exception {
    private Throwable nested = null;

    public TurbineException() {
    }

    public TurbineException(String msg) {
        super(msg);
    }

    public TurbineException(Throwable nested) {
        this.nested = nested;
    }

    public TurbineException(String msg, Throwable nested) {
        super(msg);
        this.nested = nested;
    }

    public String getMessage() {
        String nestedMsg;
        StringBuffer msg = new StringBuffer();
        String ourMsg = super.getMessage();
        if (ourMsg != null) {
            msg.append(ourMsg);
        }
        if (this.nested != null && (nestedMsg = this.nested.getMessage()) != null) {
            if (ourMsg != null) {
                msg.append(": ");
            }
            msg.append(nestedMsg);
        }
        return msg.length() > 0 ? msg.toString() : null;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(System.err);
        }
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            this.printStackTrace(out, 0);
        }
    }

    public void printStackTrace(PrintWriter out, int skip) {
        String[] st = this.captureStackTrace();
        if (this.nested != null) {
            if (this.nested instanceof TurbineException) {
                ((TurbineException)this.nested).printStackTrace(out, st.length - 2);
            } else if (this.nested instanceof TurbineRuntimeException) {
                ((TurbineRuntimeException)this.nested).printStackTrace(out, st.length - 2);
            } else {
                String[] nst = this.captureStackTrace(this.nested);
                int i = 0;
                while (i < nst.length - st.length + 2) {
                    out.println(nst[i]);
                    ++i;
                }
            }
            out.print("rethrown as ");
        }
        int i = 0;
        while (i < st.length - skip) {
            out.println(st[i]);
            ++i;
        }
    }

    private String[] captureStackTrace() {
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter((Writer)sw, true));
        return this.splitStackTrace(sw.getBuffer().toString());
    }

    private String[] captureStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return this.splitStackTrace(sw.getBuffer().toString());
    }

    private String[] splitStackTrace(String stackTrace) {
        String linebreak = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }
}

