/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class VelocityScreen
extends TemplateScreen {
    protected void doBuildTemplate(RunData data, Context context) throws Exception {
    }

    protected void doBuildTemplate(RunData data) throws Exception {
        this.doBuildTemplate(data, TurbineVelocity.getContext(data));
    }

    public ConcreteElement buildTemplate(RunData data) throws Exception {
        StringElement output = null;
        String screenData = null;
        Context context = TurbineVelocity.getContext(data);
        String templateName = TurbineTemplate.getScreenTemplateName(data.getTemplateInfo().getScreenTemplate());
        if (templateName.length() > 0 && templateName.charAt(0) != '/') {
            templateName = '/' + templateName;
        }
        try {
            if (this.getLayout(data) == null) {
                TurbineVelocity.handleRequest(context, "screens" + templateName, (OutputStream)data.getResponse().getOutputStream());
            } else {
                screenData = TurbineVelocity.handleRequest(context, "screens" + templateName);
            }
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)StringUtils.stackTrace(e));
            templateName = TurbineResources.getString("template.error", "/error.vm");
            if (templateName.length() > 0 && templateName.charAt(0) != '/') {
                templateName = '/' + templateName;
            }
            screenData = TurbineVelocity.handleRequest(context, "screens" + templateName);
        }
        if (screenData != null) {
            output = new StringElement();
            output.setFilterState(false);
            output.addElement(screenData);
        }
        return output;
    }

    public static Context getContext(RunData data) {
        return TurbineVelocity.getContext(data);
    }
}

