/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.layouts;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.freemarker.FreeMarkerService;
import org.apache.turbine.services.freemarker.NavigationModel;
import org.apache.turbine.util.RunData;

public class FreeMarkerSiteLayout
extends Layout {
    public void doBuild(RunData data) throws Exception {
        SimpleHash context = this.getContext(data);
        ConcreteElement results = ScreenLoader.getInstance().eval(data, data.getScreen());
        String screenValue = "";
        if (results != null) {
            screenValue = results.toString();
        }
        context.put("screen_placeholder", (TemplateModel)new SimpleScalar(screenValue));
        context.put("navigation", (TemplateModel)new NavigationModel(data));
        String templateName = data.getTemplateInfo().getLayoutTemplate();
        boolean isCache = data.getParameters().getBoolean("template_cache", true);
        data.getPage().getBody().addElement((Element)this.doBuildTemplate(context, "layouts" + templateName, isCache));
    }

    protected SimpleHash getContext(RunData data) {
        FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService("FreeMarkerService");
        return fm.getContext(data);
    }

    protected SimpleHash getContext() {
        FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService("FreeMarkerService");
        return fm.getContext();
    }

    protected StringElement doBuildTemplate(SimpleHash context, String templateFile, boolean cache) throws Exception {
        FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService("FreeMarkerService");
        StringElement output = new StringElement();
        output.setFilterState(false);
        output.addElement(fm.handleRequest(context, templateFile, cache));
        return output;
    }
}

