/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.threads;

import org.apache.jcs.utils.threads.IThreadPoolRunnable;
import org.apache.jcs.utils.threads.ThreadPool;

public class ThreadPoolManager {
    private static final ThreadPoolManager singleton = new ThreadPoolManager();
    private ThreadPool pool = new ThreadPool();
    private boolean started;

    private ThreadPoolManager() {
    }

    public static void setMaxThreads(int maxThreads) {
        ThreadPoolManager.singleton.pool.setMaxThreads(maxThreads);
    }

    public static void setMinSpareThreads(int minSpareThreads) {
        ThreadPoolManager.singleton.pool.setMinSpareThreads(minSpareThreads);
    }

    public static void setMaxSpareThreads(int maxSpareThreads) {
        ThreadPoolManager.singleton.pool.setMaxSpareThreads(maxSpareThreads);
    }

    public static int getMaxThreads() {
        return ThreadPoolManager.singleton.pool.getMaxThreads();
    }

    public static int getMinSpareThreads() {
        return ThreadPoolManager.singleton.pool.getMinSpareThreads();
    }

    public static int getMaxSpareThreads() {
        return ThreadPoolManager.singleton.pool.getMaxSpareThreads();
    }

    public static ThreadPoolManager getInstance() {
        if (!ThreadPoolManager.singleton.started) {
            ThreadPoolManager threadPoolManager = singleton;
            synchronized (threadPoolManager) {
                if (!ThreadPoolManager.singleton.started) {
                    ThreadPoolManager.singleton.pool.start();
                    ThreadPoolManager.singleton.started = true;
                }
            }
        }
        return singleton;
    }

    public static void reset() {
        ThreadPoolManager threadPoolManager = singleton;
        synchronized (threadPoolManager) {
            if (ThreadPoolManager.singleton.started) {
                ThreadPoolManager.singleton.started = false;
                ThreadPoolManager.singleton.pool.shutdown();
            }
            ThreadPoolManager.singleton.pool = new ThreadPool();
        }
    }

    public void runIt(IThreadPoolRunnable r) {
        this.pool.runIt(r);
    }
}

